/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemData;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentsCommissionData;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.BillingItemsSplitParameterType;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.util.List;
import java.util.Map;

public class FinDocsUpdateFeesBatchProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map map = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_DATA_BY_GROUPING_KEY_MAP);
        EntityReference relationDescription = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CONTRACT_RELATION_DESCRIPTION_REFERENCE);
        FinanceDocumentsProperties properties = (FinanceDocumentsProperties)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENTS_PROPERTIES);
        BaseProduct product = (BaseProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        GeneralProductContractRelationData relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)handler.getUnmodifiableContractRelations(product), (EntityReference)relationDescription);
        if (null == relation) {
            return;
        }
        for (GeneralProductCommission commission : relation.getCommissions()) {
            String key;
            BillingItemData hData;
            EntityContainer commissionProperties = EntityStorage.get().resolve(commission.getCommissionProperties());
            if (commissionProperties == null || !(commissionProperties.getEntity() instanceof FeeProperties) && !(commissionProperties.getEntity() instanceof PaymentFeeProperties)) continue;
            StringBuilder sb = new StringBuilder();
            if (properties.getFeesSplitTypes().contains(BillingItemsSplitParameterType.ITEM_TYPE)) {
                sb.append("_").append(ServiceType.FEE);
            }
            if (properties.getFeesSplitTypes().contains(BillingItemsSplitParameterType.PRODUCT_TYPE)) {
                sb.append("_").append(handler.getProductType(product).name());
            }
            if (properties.getDiscountsSplitTypes().contains(BillingItemsSplitParameterType.PRODUCT_NUMBER)) {
                sb.append("_").append(FinDocsHelper.getProductNumbersSplitValue(product));
            }
            if (properties.getFeesSplitTypes().contains(BillingItemsSplitParameterType.PRICE)) {
                sb.append("_").append(String.format("%s", Double.toString(commission.getEquivalentAmount().doubleValue())));
            }
            if (properties.getFeesSplitTypes().contains(BillingItemsSplitParameterType.UID)) {
                sb.append("_").append(commission.getUid());
            }
            if ((hData = (BillingItemData)map.get(key = sb.toString())) == null) {
                hData = new BillingItemData();
                map.put(key, hData);
            }
            FinanceDocumentsCommissionData data = new FinanceDocumentsCommissionData();
            data.setProduct(product);
            data.setEquivalentAmount(commission.getEquivalentAmount());
            data.setDescription(commission.getCommissionProperties());
            hData.getFees().add(data);
        }
    }
}

