/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemData;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentsCommissionData;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;

public class FinDocsUpdateFeesBillingItemNameProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BillingItem item = (BillingItem)ctx.getObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM);
        BillingItemData biData = (BillingItemData)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_DATA);
        if (null == item || biData.getFees().isEmpty()) {
            return;
        }
        boolean useCyrillicTravellerName = (Boolean)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_USE_CYRILLIC_TRAVELLER_NAME);
        String biName = FinDocsHelper.getFinanceName(((FinanceDocumentsCommissionData)biData.getFees().get(0)).getDescription());
        if (!TextUtil.isBlank((String)biName) && !biData.getProducts().isEmpty()) {
            BaseProduct bp = (BaseProduct)biData.getProducts().get(0);
            ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
            biName = biName.replace("${air_tickets_info}", FinDocsHelper.getGroupInfo(biData.getProducts(), (ProductHandler<BaseProduct>)handler, useCyrillicTravellerName));
        }
        item.setName(biName);
    }
}

