/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.finance.BillingItemData;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.BillingItemsSplitParameterType;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.math.BigDecimal;
import java.util.Map;

public class FinDocsUpdatePenaltiesBatchProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String key;
        BillingItemData hData;
        Product air;
        Map map = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_DATA_BY_GROUPING_KEY_MAP);
        FinanceDocumentsProperties properties = (FinanceDocumentsProperties)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENTS_PROPERTIES);
        BaseProduct product = (BaseProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        BigDecimal penalty = null;
        BaseProduct mainProduct = product;
        ProductHandler mainHandler = handler;
        if (product instanceof Product && FinDocsHelper.isAppropriateMCO(air = (Product)product)) {
            penalty = AirProductHelper.getEquivalentFare((Product)air);
            if (null == penalty) {
                penalty = BigDecimal.ZERO;
            }
            if (air.getRelatedProducts().size() > 0) {
                mainProduct = (BaseProduct)air.getRelatedProducts().get(0);
                mainHandler = HandlersRegistry.get().findProductHandler(mainProduct.getClass());
            }
        }
        if (null == penalty) {
            ProductStatus status = handler.getStatus(product);
            if (ProductStatus.SELL == status) {
                BaseProduct prevProduct = handler.getPreviousProduct(product);
                if (null == prevProduct) {
                    return;
                }
                ProductHandler prevProcustHandler = HandlersRegistry.get().findProductHandler(prevProduct.getClass());
                if (ProductStatus.EXCHANGE != prevProcustHandler.getStatus(prevProduct)) {
                    return;
                }
            } else if (ProductStatus.REFUND != status) {
                return;
            }
            penalty = handler.getPenalty(product);
        }
        if (null == penalty) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (properties.getPenaltiesSplitTypes().contains(BillingItemsSplitParameterType.ITEM_TYPE)) {
            sb.append("_").append(ServiceType.PENALTY);
        }
        if (properties.getPenaltiesSplitTypes().contains(BillingItemsSplitParameterType.PRODUCT_TYPE)) {
            sb.append("_").append(mainHandler.getProductType(mainProduct).name());
        }
        if (properties.getDiscountsSplitTypes().contains(BillingItemsSplitParameterType.PRODUCT_NUMBER)) {
            sb.append("_").append(FinDocsHelper.getProductNumbersSplitValue(mainProduct));
        }
        if (properties.getPenaltiesSplitTypes().contains(BillingItemsSplitParameterType.PRICE)) {
            sb.append("_").append(String.format("%s", Double.toString(penalty.doubleValue())));
        }
        if (properties.getPenaltiesSplitTypes().contains(BillingItemsSplitParameterType.UID)) {
            sb.append("_").append(product.getUid()).append("-PENALTY");
        }
        if ((hData = (BillingItemData)map.get(key = sb.toString())) == null) {
            hData = new BillingItemData();
            map.put(key, hData);
        }
        hData.getPenalties().add(product);
    }
}

