/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemData;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class FinDocsUpdatePenaltiesBillingItemsProcessor
extends BaseProcessor {
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss.SSS");

    public void process(MessageContext ctx) throws Exception {
        EntityReference relationDescription = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CONTRACT_RELATION_DESCRIPTION_REFERENCE);
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        BillingItemData biData = (BillingItemData)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_DATA);
        if (biData.getPenalties().isEmpty()) {
            return;
        }
        BillingItem item = (BillingItem)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM);
        ProductHandler handler = HandlersRegistry.get().findProductHandler(((BaseProduct)biData.getPenalties().get(0)).getClass());
        for (BaseProduct product : biData.getPenalties()) {
            GeneralProductContractRelationData relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)handler.getUnmodifiableContractRelations(product), (EntityReference)relationDescription);
            if (null == relation) {
                String name = handler.generateShortProductName(product);
                name = TextUtil.isBlank((String)name) ? "(" + product.getUid() + ")" : name + " (" + product.getUid() + ")";
                this.logToLogAndContext(String.format("! relation (%s) for product %s is null, skip it", relationDescription.getUid(), name), ctx);
                continue;
            }
            for (GeneralProductFop fop : relation.getFops()) {
                if (!fop.getCommissions().isEmpty()) continue;
                EntityContainer ctr = (EntityContainer)EntityStorageHelper.findParentEntity((BaseEntity)product, EntityContainer.class, (EntityStorageContext)context);
                item.getFops().add(new NestedEntityReference(ctr.toReference(), fop.getUid(), Fop.class, fop.toString()));
            }
        }
        if (!biData.getComponents().isEmpty()) {
            item.getComponents().addAll(biData.getComponents());
            item.setAmount(FinDocsHelper.getVatAmount(biData.getComponents()));
            return;
        }
        VatAmount amount = new VatAmount();
        BigDecimal penalty = (BigDecimal)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_PENALTY);
        BigDecimal vat = (BigDecimal)ctx.getObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_PENALTY_VAT);
        amount.setTotalVatAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{item.getAmount().getTotal(), penalty}), MiscUtil.sum((BigDecimal[])new BigDecimal[]{item.getAmount().getVatAmount(), vat}));
        item.setAmount(amount);
    }

    private void logToLogAndContext(String message, MessageContext ctx) {
        this.log.debug(message);
        ctx.addMessage(MessageHelper.createWarningMessage((String)("[" + LocalDateTime.now().format(DTF) + "] " + message), (Object[])new Object[0]));
    }
}

