/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.finance.BillingItemData;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.BillingItemsSplitParameterType;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.util.Map;

public class FinDocsUpdateProductsBatchProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String key;
        BillingItemData hData;
        Product air;
        Map map = (Map)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_DATA_BY_GROUPING_KEY_MAP);
        BaseProduct bp = (BaseProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
        if (bp instanceof Product && FinDocsHelper.isAppropriateMCO(air = (Product)bp)) {
            return;
        }
        ProductStatus status = handler.getStatus(bp);
        if (ProductStatus.EXCHANGE == status) {
            return;
        }
        EntityReference relationDescription = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CONTRACT_RELATION_DESCRIPTION_REFERENCE);
        VatAmount price = handler.calculateProductPrice(bp, GeneralProductHelper.getContractType((EntityReference)relationDescription));
        FinanceDocumentsProperties properties = (FinanceDocumentsProperties)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_DOCUMENTS_PROPERTIES);
        StringBuilder sb = new StringBuilder();
        if (properties.getProductsSplitTypes().contains(BillingItemsSplitParameterType.ITEM_TYPE)) {
            sb.append("_").append(ServiceType.TICKET);
        }
        if (properties.getProductsSplitTypes().contains(BillingItemsSplitParameterType.PRODUCT_TYPE)) {
            sb.append("_").append(handler.getProductType(bp).name());
        }
        if (properties.getDiscountsSplitTypes().contains(BillingItemsSplitParameterType.PRODUCT_NUMBER)) {
            sb.append("_").append(FinDocsHelper.getProductNumbersSplitValue(bp));
        }
        if (properties.getProductsSplitTypes().contains(BillingItemsSplitParameterType.PRICE)) {
            sb.append("_").append(String.format("%s_%s", Double.toString(price.getTotal().doubleValue()), Double.toString(price.getVatAmount().doubleValue())));
        }
        if (properties.getProductsSplitTypes().contains(BillingItemsSplitParameterType.UID)) {
            sb.append("_").append(bp.getUid());
        }
        if ((hData = (BillingItemData)map.get(key = sb.toString())) == null) {
            hData = new BillingItemData();
            map.put(key, hData);
        }
        hData.getProducts().add(bp);
    }
}

