/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemData;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;

public class FinDocsUpdateProductsBillingItemNameProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BillingItem item = (BillingItem)ctx.getObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM);
        BillingItemData biData = (BillingItemData)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_DATA);
        if (null == item || biData.getProducts().isEmpty()) {
            return;
        }
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        boolean useCyrillicTravellerName = (Boolean)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_USE_CYRILLIC_TRAVELLER_NAME);
        BaseProduct bp = (BaseProduct)biData.getProducts().get(0);
        ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
        ProductStatus status = handler.getStatus(bp);
        BaseProduct previousProduct = handler.getPreviousProduct(bp);
        String relatedInvoiceNumber = null;
        if (status == ProductStatus.SELL && previousProduct != null && handler.getStatus(previousProduct) == ProductStatus.EXCHANGE) {
            BaseProduct firstSell = handler.getPreviousProduct(previousProduct);
            block0: for (EntityReference shipmentRef : firstSell.getReservation().getBookingFile().getShipments()) {
                for (EntityReference finDocRef : ((Shipment)EntityStorageHelper.resolve((EntityReference)shipmentRef, (EntityStorageContext)context).getEntity()).getFinanceDocuments()) {
                    EntityContainer finDocCtr = EntityStorageHelper.resolve((EntityReference)finDocRef, (EntityStorageContext)context);
                    if (((FinanceDocument)finDocCtr.getEntity()).getType() != FinanceDocumentType.INVOICE && ((FinanceDocument)finDocCtr.getEntity()).getType() != FinanceDocumentType.INVOICE_DETAILED) continue;
                    for (NestedEntityReference billingItemRef : ((FinanceDocument)finDocCtr.getEntity()).getBillingItems()) {
                        BillingItem bi = (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)billingItemRef, (EntityStorageContext)context);
                        for (NestedEntityReference fopRef : bi.getFops()) {
                            BaseProduct product = BookingHelper.getProductByFop((NestedEntityReference)fopRef, (EntityStorageContext)context);
                            if (!firstSell.equals((Object)product)) continue;
                            relatedInvoiceNumber = TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)finDocCtr.getEntity()));
                            break block0;
                        }
                    }
                }
            }
        }
        String biName = handler.getBillingItemName(bp, relatedInvoiceNumber);
        item.setName(biName.replace("$group_info", FinDocsHelper.getGroupInfo(biData.getProducts(), (ProductHandler<BaseProduct>)handler, useCyrillicTravellerName)));
    }
}

