/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemData;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.findocs.FinDocsHelper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class FinDocsUpdateProductsBillingItemsProcessor
extends BaseProcessor {
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss.SSS");

    public void process(MessageContext ctx) throws Exception {
        BillingItem item = (BillingItem)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM);
        BillingItemData data = (BillingItemData)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_BILLING_ITEM_DATA);
        if (data.getProducts().isEmpty()) {
            return;
        }
        EntityReference relationDescription = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CONTRACT_RELATION_DESCRIPTION_REFERENCE);
        EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        ProductHandler handler = HandlersRegistry.get().findProductHandler(((BaseProduct)data.getProducts().get(0)).getClass());
        for (BaseProduct product : data.getProducts()) {
            GeneralProductContractRelationData relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)handler.getUnmodifiableContractRelations(product), (EntityReference)relationDescription);
            if (null == relation) continue;
            EntityContainer ctr = (EntityContainer)EntityStorageHelper.findParentEntity((BaseEntity)product, EntityContainer.class, (EntityStorageContext)context);
            boolean found = false;
            for (GeneralProductFop fop : relation.getFops()) {
                if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) continue;
                item.getFops().add(new NestedEntityReference(ctr.toReference(), fop.getUid(), Fop.class, fop.toString()));
                found = true;
            }
            if (found) continue;
            String name = handler.generateShortProductName(product);
            name = TextUtil.isBlank((String)name) ? "(" + product.getUid() + ")" : name + " (" + product.getUid() + ")";
            this.warnToLogAndContext("product has no fops, " + name, ctx);
        }
        if (!data.getComponents().isEmpty()) {
            item.getComponents().addAll(data.getComponents());
            item.setAmount(FinDocsHelper.getVatAmount(data.getComponents()));
            return;
        }
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal vat = BigDecimal.ZERO;
        for (BaseProduct product : data.getProducts()) {
            VatAmount price = handler.calculateProductPrice(product, GeneralProductHelper.getContractType((EntityReference)relationDescription));
            total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, price.getTotal()});
            if (handler.getPenalty(product) != null) {
                total = total.subtract(handler.getPenalty(product));
            }
            vat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{vat, price.getVatAmount()});
            BaseProduct prev = handler.getPreviousProduct(product);
            if (prev == null) continue;
            ProductStatus status = handler.getStatus(product);
            ProductHandler prevHandler = HandlersRegistry.get().findProductHandler(prev.getClass());
            ProductStatus prevStatus = prevHandler.getStatus(prev);
            if (ProductStatus.SELL != status || ProductStatus.EXCHANGE != prevStatus) continue;
            VatAmount prevPrice = handler.calculateProductPrice(prev, GeneralProductHelper.getContractType((EntityReference)relationDescription));
            total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, prevPrice.getTotal()});
            vat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{vat, prevPrice.getVatAmount()});
        }
        VatAmount amount = new VatAmount();
        amount.setTotalVatAmount(item.getAmount().getTotal().add(total), item.getAmount().getVatAmount().add(vat));
        item.setAmount(amount);
    }

    private void warnToLogAndContext(String message, MessageContext ctx) {
        this.log.warn(message);
        ctx.addMessage(MessageHelper.createWarningMessage((String)("[" + LocalDateTime.now().format(DTF) + "] " + message), (Object[])new Object[0]));
    }
}

