/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.findocs;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;

public class FinDocsUpdateShipmentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SHIPMENT);
        EntityReference customer = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_CUSTOMER_REFERENCE);
        EntityReference payer = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_PAYER_REFERENCE);
        EntityReference supplier = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_SUPPLIER_REFERENCE);
        EntityReference agent = (EntityReference)ctx.getObject((Enum)IBusFinanceContextKeys.FINDOCS_AGENT_REFERENCE);
        List lst = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINDOCS_PRODUCTS_REFERENCES);
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        for (NestedEntityReference productRef : lst) {
            BaseProduct bp = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productRef, (EntityStorageContext)sc);
            ProductHandler findProductHandler = HandlersRegistry.get().findProductHandler(bp.getClass());
            Date issueDate = findProductHandler.findIssueDate(bp);
            if (issueDate == null) continue;
            shipment.setDate(issueDate);
        }
        shipment.setCustomer(customer);
        shipment.setAgent(agent);
        shipment.setPayer(payer);
        shipment.setSupplier(supplier);
    }
}

