/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.initialization;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.FinanceInitializationTaskData;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;

public class FinanceInitializationCalculateOperationDateProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        FinanceInitializationTaskData financeInitializationTaskData = (FinanceInitializationTaskData)context.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_DATA);
        if (financeInitializationTaskData.isStopped()) {
            context.putObject((Enum)IBusFinanceContextKeys.OPERATION_DATE, (Object)financeInitializationTaskData.getOperationDate());
            this.log.debug("operation date found " + financeInitializationTaskData.getOperationDate());
        } else {
            int balancesDepth = 0;
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityType", (Object)ChartOfAccountsSettings.class.getName()));
            List basicSystemSettingsIndexes = EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData();
            for (BasicSystemSettingsIndex basicSystemSettingsIndex : basicSystemSettingsIndexes) {
                EntityContainer baseSystemSettingsContainer = EntityStorage.get().resolve(basicSystemSettingsIndex.getSource());
                if (baseSystemSettingsContainer == null) continue;
                ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)baseSystemSettingsContainer.getEntity();
                balancesDepth = Math.max(balancesDepth, chartOfAccountsSettings.getBalancesDepth());
            }
            Date date = new Date();
            date = MiscUtil.addDaysToDate((Date)date, (int)(-balancesDepth));
            date = MiscUtil.clearTime((Date)date);
            context.putObject((Enum)IBusFinanceContextKeys.OPERATION_DATE, (Object)date);
            financeInitializationTaskData.setOperationDate(date);
            this.log.debug("operation date created " + financeInitializationTaskData.getOperationDate());
        }
    }
}

