/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.initialization;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceIbusHelper;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceTransactionHelper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FinanceInitializationCreateCustomerBalancesProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        ChartOfAccountsSettings chartOfAccountsSettings;
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings;
        Map chartOfAccountsElementsMap = (Map)context.getMandatoryObject((Enum)IBusFinanceContextKeys.NEW_CHART_OF_ACCOUNTS_ELEMENTS_MAP);
        Date operationDate = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.OPERATION_DATE);
        EntityReference organization = (EntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.ORGANIZATION_REFERENCE);
        EntityContainer chartOfAccountsSettingsContainer = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.CHART_OF_ACCOUNTS_SETTINGS_CONTAINER);
        if (chartOfAccountsSettingsContainer != null && (chartOfAccountsElementSettings = (chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity()).getCustomerSettings()).isEnabled()) {
            List<FinanceIbusHelper.DimensionInfo> dimensionInfos = FinanceIbusHelper.getDimensionInfos(chartOfAccountsElementSettings);
            List dimensionInfosCombinations = CollectionUtil.combinations(new HashSet<FinanceIbusHelper.DimensionInfo>(dimensionInfos));
            for (ChartOfAccountsElementType chartOfAccountsElementType : Arrays.asList(ChartOfAccountsElementType.CUSTOMER, ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE, ChartOfAccountsElementType.CUSTOMER_HOLD_PAYMENT)) {
                FinanceIbusHelper.StatusType type = null;
                if (chartOfAccountsElementType == ChartOfAccountsElementType.CUSTOMER) {
                    type = FinanceIbusHelper.StatusType.ACTIVE;
                } else if (chartOfAccountsElementType == ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE) {
                    type = FinanceIbusHelper.StatusType.HOLD_SERVICE;
                } else if (chartOfAccountsElementType == ChartOfAccountsElementType.CUSTOMER_HOLD_PAYMENT) {
                    type = FinanceIbusHelper.StatusType.HOLD_PAYMENT;
                }
                Map<DictionaryReference<CurrencyInfo>, List<Map<FinanceIbusHelper.DimensionInfo, Object>>> dimensionsValuesCombinations2 = FinanceIbusHelper.collectBillingTransactionsDimensionsValuesCombinations((EntityReference<Organization>)organization, operationDate, dimensionInfos, type, FinanceIbusHelper.OrganizationRole.SUPPLIER);
                for (Map.Entry<DictionaryReference<CurrencyInfo>, List<Map<FinanceIbusHelper.DimensionInfo, Object>>> entry : dimensionsValuesCombinations2.entrySet()) {
                    DictionaryReference<CurrencyInfo> currency = entry.getKey();
                    List<Map<FinanceIbusHelper.DimensionInfo, Object>> dimensionsValuesCombinations = entry.getValue();
                    dimensionsValuesCombinations.add(Collections.emptyMap());
                    int dimensionInfosCombinationCount = 0;
                    block2: for (Set dimensionInfosCombination : dimensionInfosCombinations) {
                        ++dimensionInfosCombinationCount;
                        EntityContainer<ChartOfAccountsElement> chartOfAccountsElementContainer = FinanceTransactionHelper.findChartOfAccountsElement(chartOfAccountsElementsMap, (EntityReference<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer.toReference(), (EntityReference<Organization>)organization, chartOfAccountsElementType, currency);
                        HashSet<String> processedDimensionsValuesCombinations = new HashSet<String>();
                        int dimensionsValuesCombinationCount = 0;
                        block3: for (Map<FinanceIbusHelper.DimensionInfo, Object> dimensionsValuesCombination : dimensionsValuesCombinations) {
                            BigDecimal credit;
                            BigDecimal debit;
                            Date endCalculationDate;
                            Date startCalculationDate;
                            boolean dirtyBalanceCalculation;
                            this.log.debug("processing -> " + chartOfAccountsElementContainer.getEntity() + " -> " + dimensionInfosCombinationCount + "/" + dimensionInfosCombinations.size() + " - " + ++dimensionsValuesCombinationCount + "/" + dimensionsValuesCombinations.size());
                            Object dimension1Object = null;
                            Object dimension2Object = null;
                            Object dimension3Object = null;
                            HashMap<FinanceHelper.Dimension, String> dimensions = new HashMap<FinanceHelper.Dimension, String>();
                            HashMap<FinanceIbusHelper.DimensionInfo, Object> actualDimensionsValuesCombination = new HashMap<FinanceIbusHelper.DimensionInfo, Object>();
                            for (FinanceIbusHelper.DimensionInfo dimensionInfo : dimensionInfosCombination) {
                                Object dimensionObject = dimensionsValuesCombination.get(dimensionInfo);
                                if (dimensionObject == null) continue block3;
                                String dimensionValue = FinanceIbusHelper.getBillingTransactionDimensionValue(dimensionInfo.getDimensionType(), dimensionObject);
                                actualDimensionsValuesCombination.put(dimensionInfo, dimensionObject);
                                if (dimensionInfo.getDimension() == FinanceHelper.Dimension.DIMENSION_1) {
                                    dimension1Object = dimensionObject;
                                    dimensions.put(FinanceHelper.Dimension.DIMENSION_1, dimensionValue);
                                    continue;
                                }
                                if (dimensionInfo.getDimension() == FinanceHelper.Dimension.DIMENSION_2) {
                                    dimension2Object = dimensionObject;
                                    dimensions.put(FinanceHelper.Dimension.DIMENSION_2, dimensionValue);
                                    continue;
                                }
                                if (dimensionInfo.getDimension() != FinanceHelper.Dimension.DIMENSION_3) continue;
                                dimension3Object = dimensionObject;
                                dimensions.put(FinanceHelper.Dimension.DIMENSION_3, dimensionValue);
                            }
                            String key = String.format("%s_%s_%s", dimension1Object, dimension2Object, dimension3Object);
                            if (processedDimensionsValuesCombinations.contains(key)) continue;
                            processedDimensionsValuesCombinations.add(key);
                            do {
                                startCalculationDate = new Date();
                                debit = FinanceIbusHelper.calculateBillingTransactionsBalance((EntityReference<Organization>)organization, operationDate, actualDimensionsValuesCombination, BillingTransactionCategory.DEBIT, type, FinanceIbusHelper.OrganizationRole.SUPPLIER, currency);
                                credit = FinanceIbusHelper.calculateBillingTransactionsBalance((EntityReference<Organization>)organization, operationDate, actualDimensionsValuesCombination, BillingTransactionCategory.CREDIT, type, FinanceIbusHelper.OrganizationRole.SUPPLIER, currency);
                                endCalculationDate = new Date();
                            } while (dirtyBalanceCalculation = FinanceIbusHelper.isDirtyBillingTransactionBalance((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementContainer.toReference(), operationDate, startCalculationDate, endCalculationDate, dimensions));
                            OpeningBalance balance = FinanceHelper.getBalance((EntityReference)chartOfAccountsElementContainer.toReference(), (Date)operationDate, (Date)operationDate, dimensions);
                            if (balance == null) {
                                balance = new OpeningBalance();
                                balance.setOrganizationUid(organization.getUid());
                                balance.setAccountUid(chartOfAccountsElementContainer.getUid());
                                balance.setOperationDate(operationDate);
                                balance.setCalculationDate(operationDate);
                                balance.setDimension1((String)dimensions.get(FinanceHelper.Dimension.DIMENSION_1));
                                balance.setDimension2((String)dimensions.get(FinanceHelper.Dimension.DIMENSION_2));
                                balance.setDimension3((String)dimensions.get(FinanceHelper.Dimension.DIMENSION_3));
                            }
                            balance.setDebit(balance.getDebit() + ModelHelper.bigDecimal2Long((BigDecimal)(chartOfAccountsElementType == ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE ? credit : debit)));
                            balance.setCredit(balance.getCredit() + ModelHelper.bigDecimal2Long((BigDecimal)(chartOfAccountsElementType == ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE ? debit : credit)));
                            AssetsStorage.get().save((BaseAsset)balance);
                            if (!dimensionInfosCombination.isEmpty()) continue;
                            continue block2;
                        }
                    }
                }
            }
        }
    }
}

