/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.save.base.payment.document;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.CreditSlip;
import com.gridnine.xtrip.common.model.finance.CreditSlipType;
import com.gridnine.xtrip.common.model.finance.DebitSlip;
import com.gridnine.xtrip.common.model.finance.DebitSlipType;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceTransactionHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class FinanceSaveBasePaymentDocumentAgencyTransactionDatasTargetsProvider
extends BaseTargetsProvider<FinanceTransactionHelper.TransactionData> {
    public Collection<FinanceTransactionHelper.TransactionData> getTargets(MessageContext context) throws Exception {
        EntityContainer paymentDocumentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BASE_PAYMEMT_DOCUMENT_CONTAINER);
        if (!DebitSlip.class.isAssignableFrom(paymentDocumentContainer.getEntityType()) && !CreditSlip.class.isAssignableFrom(paymentDocumentContainer.getEntityType())) {
            return Collections.emptyList();
        }
        BasePaymentDocument paymentDocument = (BasePaymentDocument)paymentDocumentContainer.getEntity();
        if (paymentDocument.getDate() == null || paymentDocument.getTotalAmount() == null || paymentDocument.getTotalAmount().getValue() == null || paymentDocument.getTotalAmount().getCurrency() == null) {
            return Collections.emptyList();
        }
        ArrayList<FinanceTransactionHelper.TransactionData> transactionDatas = new ArrayList<FinanceTransactionHelper.TransactionData>();
        EntityReference agency = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.AGENCY_REFERENCE);
        EntityContainer chartOfAccountsSettingsContainer = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.AGENCY_CHART_OF_ACCOUNTS_SETTINGS_CONTAINER);
        if (chartOfAccountsSettingsContainer != null) {
            ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity();
            if (FinanceHelper.isChartOfAccountsSettingsDisabled((ChartOfAccountsSettings)chartOfAccountsSettings)) {
                return Collections.emptyList();
            }
            ChartOfAccountsElementType creditChartOfAccountsElementType = null;
            BasicChartOfAccountsElementSettings creditChartOfAccountsElementSettings = null;
            FinanceTransactionHelper.SplitData creditSplitData = null;
            ChartOfAccountsElementType debitChartOfAccountsElementType = null;
            BasicChartOfAccountsElementSettings debitChartOfAccountsElementSettings = null;
            FinanceTransactionHelper.SplitData debitSplitData = null;
            if (DebitSlip.class.isAssignableFrom(paymentDocumentContainer.getEntityType())) {
                DebitSlip debitSlip = (DebitSlip)paymentDocument;
                if (debitSlip.getType() == DebitSlipType.CASH_REGISTER) {
                    creditChartOfAccountsElementType = ChartOfAccountsElementType.CASH_REGISTER;
                    creditChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)creditChartOfAccountsElementType);
                    if (creditChartOfAccountsElementSettings.isEnabled()) {
                        creditSplitData = new FinanceTransactionHelper.SplitData();
                        creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
                        creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
                        debitChartOfAccountsElementType = ChartOfAccountsElementType.CASH;
                        debitChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)debitChartOfAccountsElementType);
                        if (debitChartOfAccountsElementSettings.isEnabled()) {
                            debitSplitData = new FinanceTransactionHelper.SplitData();
                            debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
                            debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
                            FinanceTransactionHelper.TransactionData transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BasePaymentDocument>)paymentDocumentContainer, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, (EntityReference<Organization>)agency, null, null, (EntityReference<Person>)debitSlip.getCashier(), (EntityReference<Person>)debitSlip.getPerson(), paymentDocument.getTotalAmount().getValue(), debitSplitData, creditSplitData);
                            if (transactionData != null) {
                                transactionDatas.add(transactionData);
                            }
                        }
                    }
                } else if (debitSlip.getType() == DebitSlipType.TRANSFER && (creditChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)(creditChartOfAccountsElementType = ChartOfAccountsElementType.CASH))).isEnabled()) {
                    creditSplitData = new FinanceTransactionHelper.SplitData();
                    creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
                    creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
                    debitChartOfAccountsElementType = ChartOfAccountsElementType.TRANSFER;
                    debitChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)debitChartOfAccountsElementType);
                    if (debitChartOfAccountsElementSettings.isEnabled()) {
                        debitSplitData = new FinanceTransactionHelper.SplitData();
                        debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
                        debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
                        FinanceTransactionHelper.TransactionData transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BasePaymentDocument>)paymentDocumentContainer, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, (EntityReference<Organization>)agency, null, null, (EntityReference<Person>)debitSlip.getPerson(), (EntityReference<Person>)debitSlip.getCashier(), MiscUtil.negate((BigDecimal)paymentDocument.getTotalAmount().getValue()), debitSplitData, creditSplitData);
                        if (transactionData != null) {
                            transactionDatas.add(transactionData);
                        }
                    }
                }
            } else if (CreditSlip.class.isAssignableFrom(paymentDocumentContainer.getEntityType())) {
                CreditSlip creditSlip = (CreditSlip)paymentDocument;
                if (creditSlip.getType() == CreditSlipType.TRANSFER) {
                    creditChartOfAccountsElementType = ChartOfAccountsElementType.CASH;
                    creditChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)creditChartOfAccountsElementType);
                    if (creditChartOfAccountsElementSettings.isEnabled()) {
                        creditSplitData = new FinanceTransactionHelper.SplitData();
                        creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
                        creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
                        debitChartOfAccountsElementType = ChartOfAccountsElementType.TRANSFER;
                        debitChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)debitChartOfAccountsElementType);
                        if (debitChartOfAccountsElementSettings.isEnabled()) {
                            debitSplitData = new FinanceTransactionHelper.SplitData();
                            debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
                            debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
                            FinanceTransactionHelper.TransactionData transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BasePaymentDocument>)paymentDocumentContainer, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, (EntityReference<Organization>)agency, null, null, (EntityReference<Person>)creditSlip.getPerson(), (EntityReference<Person>)creditSlip.getCashier(), paymentDocument.getTotalAmount().getValue(), debitSplitData, creditSplitData);
                            if (transactionData != null) {
                                transactionDatas.add(transactionData);
                            }
                        }
                    }
                } else if (creditSlip.getType() == CreditSlipType.BANK && (creditChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)(creditChartOfAccountsElementType = ChartOfAccountsElementType.CASH))).isEnabled()) {
                    creditSplitData = new FinanceTransactionHelper.SplitData();
                    creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
                    creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
                    debitChartOfAccountsElementType = ChartOfAccountsElementType.BANK;
                    debitChartOfAccountsElementSettings = null;
                    debitSplitData = new FinanceTransactionHelper.SplitData();
                    debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
                    debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
                    FinanceTransactionHelper.TransactionData transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BasePaymentDocument>)paymentDocumentContainer, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, (EntityReference<Organization>)agency, null, null, (EntityReference<Person>)creditSlip.getPerson(), (EntityReference<Person>)creditSlip.getCashier(), paymentDocument.getTotalAmount().getValue(), debitSplitData, creditSplitData);
                    if (transactionData != null) {
                        transactionDatas.add(transactionData);
                    }
                }
            }
        }
        return transactionDatas;
    }
}

