/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.save.base.payment.document;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.CreditSlip;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.DebitSlip;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceTransactionHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class FinanceSaveBasePaymentDocumentSupplierTransactionDatasTargetsProvider
extends BaseTargetsProvider<FinanceTransactionHelper.TransactionData> {
    public Collection<FinanceTransactionHelper.TransactionData> getTargets(MessageContext context) throws Exception {
        EntityContainer paymentDocumentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BASE_PAYMEMT_DOCUMENT_CONTAINER);
        if (DebitSlip.class.isAssignableFrom(paymentDocumentContainer.getEntityType()) || CreditSlip.class.isAssignableFrom(paymentDocumentContainer.getEntityType())) {
            return Collections.emptyList();
        }
        BasePaymentDocument paymentDocument = (BasePaymentDocument)paymentDocumentContainer.getEntity();
        if (paymentDocument.getDate() == null || paymentDocument.getTotalAmount() == null || paymentDocument.getTotalAmount().getValue() == null || paymentDocument.getTotalAmount().getCurrency() == null) {
            return Collections.emptyList();
        }
        EntityContainer contractContainer = EntityStorage.get().resolve((EntityReference)paymentDocument.getContract());
        if (contractContainer == null || ((Contract)contractContainer.getEntity()).getContractType() == null) {
            return Collections.emptyList();
        }
        ContractType contractType = ((Contract)contractContainer.getEntity()).getContractType();
        ArrayList<FinanceTransactionHelper.TransactionData> transactionDatas = new ArrayList<FinanceTransactionHelper.TransactionData>();
        EntityReference organization = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.CUSTOMER_REFERENCE);
        EntityReference supplier = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.SUPPLIER_REFERENCE);
        EntityReference<Organization> customer = null;
        EntityContainer chartOfAccountsSettingsContainer = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.CUSTOMER_CHART_OF_ACCOUNTS_SETTINGS_CONTAINER);
        if (chartOfAccountsSettingsContainer != null) {
            FinanceTransactionHelper.TransactionData transactionData;
            ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity();
            if (FinanceHelper.isChartOfAccountsSettingsDisabled((ChartOfAccountsSettings)chartOfAccountsSettings)) {
                return Collections.emptyList();
            }
            ChartOfAccountsElementType creditChartOfAccountsElementType = null;
            BasicChartOfAccountsElementSettings creditChartOfAccountsElementSettings = null;
            FinanceTransactionHelper.SplitData creditSplitData = null;
            ChartOfAccountsElementType debitChartOfAccountsElementType = null;
            BasicChartOfAccountsElementSettings debitChartOfAccountsElementSettings = null;
            FinanceTransactionHelper.SplitData debitSplitData = null;
            creditChartOfAccountsElementType = ChartOfAccountsElementType.BANK;
            creditChartOfAccountsElementSettings = null;
            creditSplitData = new FinanceTransactionHelper.SplitData();
            creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
            creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
            debitChartOfAccountsElementType = ChartOfAccountsElementType.SUPPLIER;
            debitChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)debitChartOfAccountsElementType);
            if (!debitChartOfAccountsElementSettings.isEnabled()) {
                debitChartOfAccountsElementType = ChartOfAccountsElementType.EXPENSE;
                debitChartOfAccountsElementSettings = null;
            }
            debitSplitData = new FinanceTransactionHelper.SplitData();
            debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
            debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
            BigDecimal amount = paymentDocument.getTotalAmount().getValue();
            if (DebitBankTransferOrder.class.isAssignableFrom(paymentDocumentContainer.getEntityType())) {
                if (contractType == ContractType.VENDOR) {
                    amount = MiscUtil.negate((BigDecimal)amount);
                }
            } else if (contractType != ContractType.VENDOR) {
                amount = MiscUtil.negate((BigDecimal)amount);
            }
            if ((transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BasePaymentDocument>)paymentDocumentContainer, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, (EntityReference<Organization>)organization, (EntityReference<Organization>)supplier, customer, null, null, amount, debitSplitData, creditSplitData)) != null) {
                transactionDatas.add(transactionData);
            }
        }
        return transactionDatas;
    }
}

