/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;

public class ShipmentsDeleteUpdatePrepaymentFinanceDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityContainer shipmentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        List vendorDatas = (List)context.getObject((Enum)IBusFinanceContextKeys.VENDOR_DATA_LIST);
        EntityContainer financeDocumentContainer = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        if (financeDocumentContainer == null) {
            return;
        }
        FinanceDocument document = (FinanceDocument)financeDocumentContainer.getEntity();
        VendorFinanceDocumentData vendorFinanceDocumentData = document.getVendorFinanceDocumentData();
        EntityReference vendor = document.getVendor();
        if (document.isVendorDocument() && vendorDatas != null) {
            vendorDatas.stream().filter(item -> item.getVendor().equals((Object)vendor)).filter(item -> item.getVendorFinanceDocumentData().getType() == vendorFinanceDocumentData.getType() && item.getVendorFinanceDocumentData().getVendorNumber().equals(vendorFinanceDocumentData.getVendorNumber()) && MiscUtil.compare((Date)item.getVendorFinanceDocumentData().getVendorDate(), (Date)vendorFinanceDocumentData.getVendorDate()) == 0).forEach(item -> {
                item.getVendorFinanceDocumentData().setNumber(null);
                item.getVendorFinanceDocumentData().setDate(null);
                item.getVendorFinanceDocumentData().setSequenceNumber(null);
            });
        }
        document.getRelatedShipments().remove(shipmentContainer.toReference());
        ((Shipment)shipmentContainer.getEntity()).getPrepaymentFinanceDocuments().remove(financeDocumentContainer.toReference());
    }
}

