/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.attach;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ShipmentsAttachAddFinalMessagesProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        Collection shipments = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINERS);
        List usedShipments = (List)context.getMandatoryObject((Enum)IBusFinanceContextKeys.USED_SHIPMENTS);
        List mismatchedParameters = (List)context.getObject((Enum)IBusFinanceContextKeys.MISMATCHED_PARAMETERS);
        for (EntityContainer shipment : shipments) {
            if (usedShipments.contains(shipment)) continue;
            MessageType messageType = usedShipments.isEmpty() ? MessageType.ERROR : MessageType.WARNING;
            String message = mismatchedParameters.stream().filter(item -> item.getShipments().contains(shipment)).map(item -> item.getParameterName() + ":\n" + L10nResourcesManager.getStr((String)"FinanceShipments_requiredValue", (Object[])new Object[0]) + " - " + item.getRequiredValue() + "\n" + L10nResourcesManager.getStr((String)"FinanceShipments_currentValue", (Object[])new Object[0]) + " - " + item.getCurrentValue()).collect(Collectors.joining("\n"));
            context.addMessage(MessagesHelper.createMessage((MessageType)messageType, (String)Messages.FinanceShipments_attachShipmentsIsNotAttached, (Object[])new Object[]{((Shipment)shipment.getEntity()).getNumber(), TextUtil.nonBlank((String)message) ? "\n" + message : ""}));
        }
    }
}

