/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.attach;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;

public class ShipmentsAttachLockAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        EntityReference financeDocumentReference = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE);
        Collection shipmentReferences = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_REFERENCES);
        ArrayList<NamedLock> namedLocks = new ArrayList<NamedLock>();
        try {
            LinkedHashSet<EntityReference> referencesToLock = new LinkedHashSet<EntityReference>();
            referencesToLock.add(financeDocumentReference);
            referencesToLock.addAll(shipmentReferences);
            for (EntityReference reference : referencesToLock) {
                namedLocks.add(this.lock(reference));
            }
            ctx.putObject((Enum)IBusFinanceContextKeys.LOCKS_LIST, namedLocks);
        }
        catch (Throwable t) {
            for (NamedLock namedLock : namedLocks) {
                this.unlock(namedLock);
            }
            throw t;
        }
    }

    public void after(MessageContext ctx) throws Exception {
        Collection namedLocks = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.LOCKS_LIST);
        for (NamedLock namedLock : namedLocks) {
            this.unlock(namedLock);
        }
        ctx.removeObject((Enum)IBusFinanceContextKeys.LOCKS_LIST);
    }

    private NamedLock lock(EntityReference<?> reference) throws Exception {
        NamedLock namedLock = LockUtil.getLockManager().getLock((Object)LockUtil.getLockKey(reference), TimeUnit.MINUTES.toMillis(5L));
        if (!namedLock.tryLock(5L, TimeUnit.MINUTES)) {
            throw new Exception("unable to get lock for " + namedLock.getName());
        }
        return namedLock;
    }

    private void unlock(NamedLock lock) {
        try {
            lock.unlock();
        }
        catch (Exception e) {
            this.log.error("unable to unlock " + lock.getName(), (Throwable)e);
        }
        finally {
            try {
                lock.close();
            }
            catch (Exception e) {
                this.log.error("unable to close lock for " + lock.getName(), (Throwable)e);
            }
        }
    }
}

