/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.attach;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentHolder;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ShipmentsAttachProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityReference financeDocumentReference = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE);
        EntityContainer financeDocumentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        ShipmentHolder shipmentHolder = (ShipmentHolder)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDER);
        FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch = (FinanceDocumentsIbusHelper.ShipmentsBatch)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCH);
        List usedShipments = (List)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.USED_SHIPMENTS);
        FinanceDocument financeDocument = (FinanceDocument)financeDocumentContainer.getEntity();
        Set datas = shipmentHolder.getDatas().stream().filter(data -> data.getType().equals((Object)financeDocument.getType())).collect(Collectors.toSet());
        ArrayList<NestedEntityReference> billingItems = new ArrayList<NestedEntityReference>();
        if (!datas.isEmpty()) {
            List billingItemReferences = ((Shipment)shipmentHolder.getShipment().getEntity()).getBillingItems();
            Map<NestedEntityReference<BillingItemsList, BillingItem>, BillingItem> billingItemMap = FinanceDocumentHelper.getBillingItemsMap(billingItemReferences, storageContext);
            for (NestedEntityReference billingItemReference : billingItemReferences) {
                BillingItem billingItem = billingItemMap.get(billingItemReference);
                if (billingItem == null || !MiscUtil.equals((Object)shipmentHolder.getNomenclature(), (Object)billingItem.getNomenclature())) continue;
                BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext);
                if (product != null) {
                    EntityContainer vendorContract;
                    EntityReference vendorContractRef;
                    GeneralProductContractRelationData contractRelation;
                    EntityReference vendor = GeneralProductHelper.getSupplier((BaseProduct)product);
                    if (!MiscUtil.equals((Object)shipmentHolder.getVendor(), (Object)vendor)) continue;
                    if (product instanceof HotelProduct) {
                        HotelProvider hotelProvider = ((HotelProduct)product).getProvider();
                        Double hotelVatRate = HotelProductHelper.getHotelVatRate((HotelProduct)((HotelProduct)product));
                        if (!MiscUtil.equals((Object)shipmentHolder.getHotelProvider(), (Object)hotelProvider) || !MiscUtil.equals((Object)shipmentHolder.getHotelVatRate(), (Object)hotelVatRate)) continue;
                    }
                    if ((contractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product)) != null && (vendorContractRef = contractRelation.getGeneralData().getContractData().getContract()) != null && (vendorContract = EntityStorage.get().resolve(vendorContractRef)) != null) {
                        AgreementType agreementType = ((Contract)vendorContract.getEntity()).getAgreementType();
                        if (!MiscUtil.equals((Object)shipmentHolder.getVendorAgreementType(), (Object)agreementType)) continue;
                    }
                }
                billingItems.add(billingItemReference);
            }
        }
        if (!billingItems.isEmpty()) {
            if (!((Shipment)shipmentHolder.getShipment().getEntity()).getFinanceDocuments().contains(financeDocumentReference)) {
                ((Shipment)shipmentHolder.getShipment().getEntity()).getFinanceDocuments().add(financeDocumentReference);
            }
            financeDocument.getBillingItems().addAll(billingItems);
            financeDocument.getRelatedShipments().add(shipmentHolder.getShipment().toReference());
            usedShipments.add(shipmentHolder.getShipment());
            if (financeDocument.getSupplier() == null) {
                financeDocument.setSupplier(shipmentsBatch.getSupplier());
            }
            if (financeDocument.getCustomer() == null) {
                financeDocument.setCustomer(shipmentsBatch.getCustomer());
            }
            if (financeDocument.getPayer() == null) {
                financeDocument.setPayer(shipmentsBatch.getPayer());
            }
            if (financeDocument.getContract() == null) {
                financeDocument.setContract(shipmentsBatch.getContract());
            }
            if (financeDocument.getCurrency() == null) {
                financeDocument.setCurrency(shipmentsBatch.getCurrency());
            }
        }
    }
}

