/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.attach;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ShipmentsAttachSearchShipmentsBatchProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        List mismatchedParameters = (List)context.getObject((Enum)IBusFinanceContextKeys.MISMATCHED_PARAMETERS);
        Collection batches = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCHES);
        EntityContainer financeDocument = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch = batches.stream().filter(item -> this.isMatchesParameters((EntityContainer<FinanceDocument>)financeDocument, (FinanceDocumentsIbusHelper.ShipmentsBatch)item)).findFirst().orElse(null);
        context.putObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCH, (Object)shipmentsBatch);
        if (shipmentsBatch != null) {
            batches.stream().filter(item -> !item.equals(shipmentsBatch)).forEach(item -> mismatchedParameters.addAll(this.getMismatchedParameters(shipmentsBatch, (FinanceDocumentsIbusHelper.ShipmentsBatch)item, storageContext)));
        }
    }

    private boolean isMatchesParameters(EntityContainer<FinanceDocument> financeDocument, FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch) {
        EntityReference requiredSupplier = ((FinanceDocument)financeDocument.getEntity()).getSupplier();
        EntityReference requiredCustomer = ((FinanceDocument)financeDocument.getEntity()).getCustomer();
        EntityReference<Organization> requiredPayer = null;
        if (((FinanceDocument)financeDocument.getEntity()).getPayer() != null) {
            requiredPayer = ShipmentHelper.getPayerOrganization((EntityReference<? extends BaseProfile>)((FinanceDocument)financeDocument.getEntity()).getPayer());
        }
        EntityReference requiredContract = ((FinanceDocument)financeDocument.getEntity()).getContract();
        DictionaryReference requiredCurrency = ((FinanceDocument)financeDocument.getEntity()).getCurrency();
        EntityReference<Organization> supplier = shipmentsBatch.getSupplier();
        EntityReference<Organization> customer = shipmentsBatch.getCustomer();
        EntityReference<Organization> payer = null;
        if (shipmentsBatch.getPayer() != null) {
            payer = ShipmentHelper.getPayerOrganization(shipmentsBatch.getPayer());
        }
        EntityReference<Contract> contract = shipmentsBatch.getContract();
        DictionaryReference<CurrencyInfo> currency = shipmentsBatch.getCurrency();
        if (requiredSupplier != null && !MiscUtil.equals((Object)requiredSupplier, supplier)) {
            return false;
        }
        if (requiredCustomer != null && !MiscUtil.equals((Object)requiredCustomer, customer)) {
            return false;
        }
        if (requiredPayer != null && !MiscUtil.equals(requiredPayer, payer)) {
            return false;
        }
        if (requiredContract != null && !MiscUtil.equals((Object)requiredContract, contract)) {
            return false;
        }
        return requiredCurrency == null || MiscUtil.equals((Object)requiredCurrency, currency);
    }

    private List<FinanceDocumentsIbusHelper.MismatchedParameter> getMismatchedParameters(FinanceDocumentsIbusHelper.ShipmentsBatch requiredShipmentsBatch, FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch, EntityStorageContext storageContext) {
        FinanceDocumentsIbusHelper.MismatchedParameter mismatchedParameter;
        ArrayList<FinanceDocumentsIbusHelper.MismatchedParameter> parameters = new ArrayList<FinanceDocumentsIbusHelper.MismatchedParameter>();
        EntityReference<Organization> requiredSupplier = requiredShipmentsBatch.getSupplier();
        EntityReference<Organization> requiredCustomer = requiredShipmentsBatch.getCustomer();
        EntityReference<Organization> requiredPayer = null;
        if (requiredShipmentsBatch.getPayer() != null) {
            requiredPayer = ShipmentHelper.getPayerOrganization(requiredShipmentsBatch.getPayer());
        }
        EntityReference<Contract> requiredContract = requiredShipmentsBatch.getContract();
        DictionaryReference<CurrencyInfo> requiredCurrency = requiredShipmentsBatch.getCurrency();
        EntityReference<Organization> supplier = shipmentsBatch.getSupplier();
        EntityReference<Organization> customer = shipmentsBatch.getCustomer();
        EntityReference<Organization> payer = null;
        if (shipmentsBatch.getPayer() != null) {
            payer = ShipmentHelper.getPayerOrganization(shipmentsBatch.getPayer());
        }
        EntityReference<Contract> contract = shipmentsBatch.getContract();
        DictionaryReference<CurrencyInfo> currency = shipmentsBatch.getCurrency();
        if (requiredSupplier != null && !MiscUtil.equals(requiredSupplier, supplier)) {
            mismatchedParameter = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_supplier", (Object[])new Object[0]), requiredSupplier.getCaption(), supplier != null ? supplier.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            parameters.add(mismatchedParameter);
        }
        if (requiredCustomer != null && !MiscUtil.equals(requiredCustomer, customer)) {
            mismatchedParameter = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_customer", (Object[])new Object[0]), requiredCustomer.getCaption(), customer != null ? customer.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            parameters.add(mismatchedParameter);
        }
        if (requiredPayer != null && !MiscUtil.equals(requiredPayer, payer)) {
            mismatchedParameter = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_payer", (Object[])new Object[0]), requiredPayer.getCaption(), payer != null ? payer.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            parameters.add(mismatchedParameter);
        }
        if (requiredContract != null && !MiscUtil.equals(requiredContract, contract)) {
            EntityContainer contractCtr = null;
            if (contract != null) {
                contractCtr = EntityStorageHelper.resolve(contract, (EntityStorageContext)storageContext);
            }
            EntityContainer requiredContractCtr = EntityStorageHelper.resolve(requiredContract, (EntityStorageContext)storageContext);
            FinanceDocumentsIbusHelper.MismatchedParameter mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_contract", (Object[])new Object[0]), requiredContractCtr != null ? ((Contract)requiredContractCtr.getEntity()).getName() + " " + ((Contract)requiredContractCtr.getEntity()).getNumber() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]), contractCtr != null ? ((Contract)contractCtr.getEntity()).getName() + " " + ((Contract)contractCtr.getEntity()).getNumber() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            parameters.add(mismatchedParameter2);
        }
        if (requiredCurrency != null && !MiscUtil.equals(requiredCurrency, currency)) {
            mismatchedParameter = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_currency", (Object[])new Object[0]), requiredCurrency.getCode(), currency != null ? currency.getCode() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            parameters.add(mismatchedParameter);
        }
        parameters.forEach(item -> item.getShipments().addAll(shipmentsBatch.getShipments()));
        return parameters;
    }
}

