/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.create;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.rules.ShipmentsDateRulesHelper;
import com.gridnine.xtrip.server.model.ibus.finance.documents.BillingItemHoldersBatch;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import com.gridnine.xtrip.server.model.ibus.finance.shipments.ShipmentsIbusHelper;
import com.gridnine.xtrip.server.model.number.helpers.ShipmentNumberHelper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ShipmentsCreateCreateShipmentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        Date periodEnd;
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Date date = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.DATE);
        Collection shipmentReferences = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_REFERENCES);
        FinanceDocumentsIbusHelper.ProductHoldersBatch productHoldersBatch = (FinanceDocumentsIbusHelper.ProductHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDERS_BATCH);
        BillingItemHoldersBatch billingItemsHoldersBatch = (BillingItemHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDERS_BATCH);
        EntityContainer billingItemsListContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEMS_LIST_CONTAINER);
        EntityReference<Organization> supplier = productHoldersBatch.getSupplier();
        EntityReference<Organization> customer = productHoldersBatch.getCustomer();
        EntityReference<Organization> payer = productHoldersBatch.getPayer();
        EntityReference<Contract> contract = productHoldersBatch.getContract();
        DictionaryReference<CurrencyInfo> currency = productHoldersBatch.getCurrency();
        Collection<BillingItemHolder> billingItemHolders = billingItemsHoldersBatch.getBillingItemHolders();
        Shipment shipment = new Shipment();
        shipment.setDate(date);
        StringBuilder name = new StringBuilder();
        for (DictionaryReference<ShipmentCategory> category : billingItemsHoldersBatch.getCategories()) {
            if (name.length() > 0) {
                name.append(" ");
            }
            name.append(category);
        }
        String bookingFileNumbers = billingItemHolders.stream().map(item -> EntityStorageHelper.getContainer((EntityStorageContext)storageContext, (EntityReference)item.getItem().getProduct()).toReference()).distinct().map(item -> item.toString()).sorted().collect(Collectors.joining(", "));
        if (!TextUtil.isBlank((String)bookingFileNumbers)) {
            if (name.length() > 0) {
                name.append(" ");
            }
            name.append(bookingFileNumbers);
        }
        shipment.setName(name.toString());
        shipment.setSupplier(supplier);
        shipment.setCustomer(customer);
        if (billingItemsHoldersBatch.isUseTravellerAsPayer() && ProfileHelper.isRetailProfile(payer)) {
            EntityReference<Organization> traveller = billingItemHolders.stream().map(item -> (Traveller)EntityStorageHelper.resolve((NestedEntityReference)item.getItem().getTraveller(), (EntityStorageContext)storageContext)).filter(item -> item != null).map(item -> item.getPassenger()).filter(item -> item != null).findFirst().orElse(null);
            shipment.setPayer(traveller != null ? traveller : payer);
        } else {
            shipment.setPayer(payer);
        }
        shipment.setContract(ShipmentsIbusHelper.createContractReference(contract));
        shipment.setCurrency(currency);
        shipment.setAgent(ProfileHelper.getCurrentUser());
        Date periodBegin = (Date)ShipmentsDateRulesHelper.getShipmentPeriod(productHoldersBatch.getProductHolders()).getFirst();
        if (periodBegin == null) {
            periodBegin = productHoldersBatch.getProductHolders().stream().map(item -> ProductHandler.of((BaseProduct)item.getProduct()).findIssueDate(item.getProduct())).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.minimum((Date[])new Date[]{xva$0, xva$1})).orElse(null);
        }
        if ((periodEnd = (Date)ShipmentsDateRulesHelper.getShipmentPeriod(productHoldersBatch.getProductHolders()).getLast()) == null) {
            periodEnd = productHoldersBatch.getProductHolders().stream().map(item -> ProductHandler.of((BaseProduct)item.getProduct()).findIssueDate(item.getProduct())).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.maximum((Date[])new Date[]{xva$0, xva$1})).orElse(null);
        }
        shipment.setPeriodBegin(periodBegin);
        shipment.setPeriodEnd(periodEnd);
        shipment.setCategoryBookingFile(billingItemsHoldersBatch.getBookingFile());
        shipment.setCategoryProduct(billingItemsHoldersBatch.getProduct());
        shipment.setCategoryAgent(billingItemsHoldersBatch.getAgent());
        shipment.setCategoryPeriodBegin(billingItemsHoldersBatch.getPeriodBegin());
        shipment.setCategoryPeriodEnd(billingItemsHoldersBatch.getPeriodEnd());
        shipment.setCategoryPaymentCode(billingItemsHoldersBatch.getPaymentCode());
        shipment.getCostCodes().addAll(billingItemsHoldersBatch.getCostCodes());
        shipment.getCategories().clear();
        shipment.getCategories().addAll(billingItemsHoldersBatch.getCategories());
        shipment.getBillingItems().clear();
        shipment.getBillingItems().addAll(billingItemHolders.stream().map(item -> new NestedEntityReference(billingItemsListContainer, (BaseEntity)item.getItem())).collect(Collectors.toList()));
        ContractType contractType = Optional.ofNullable(EntityStorageHelper.resolve(contract, (EntityStorageContext)storageContext)).map(contractContainer -> ((Contract)contractContainer.getEntity()).getContractType()).orElse(null);
        List prepaymentDocuments = billingItemHolders.stream().map(item -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.getItem().getProduct())).filter(Objects::nonNull).distinct().flatMap(product -> product.getPrepaymentDocuments().stream()).filter(documentReference -> contractType == null || Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)documentReference, (EntityStorageContext)storageContext)).map(document -> EntityStorageHelper.resolve((EntityReference)((FinanceDocument)document.getEntity()).getContract(), (EntityStorageContext)storageContext)).map(contractContainer -> contractType.equals((Object)((Contract)contractContainer.getEntity()).getContractType())).orElse(false) != false).distinct().collect(Collectors.toList());
        shipment.getPrepaymentFinanceDocuments().clear();
        shipment.getPrepaymentFinanceDocuments().addAll(prepaymentDocuments);
        ShipmentNumberHelper.generateNumber(shipment, storageContext);
        EntityContainer shipmentContainer = EntityStorageHelper.createContainer((BaseEntity)shipment, (EntityStorageContext)storageContext);
        EntityReference shipmentReference = shipmentContainer.toReference();
        shipmentReferences.add(shipmentReference);
        for (Object billingItem : billingItemHolders.stream().map(item -> item.getItem()).collect(Collectors.toList())) {
            billingItem.setShipment(shipmentReference);
        }
        List componentReferences = billingItemHolders.stream().flatMap(item -> item.getItem().getFopComponents().stream()).collect(Collectors.toList());
        for (NestedEntityReference componentReference : componentReferences) {
            FopComponent component = (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)componentReference, (EntityStorageContext)storageContext);
            if (component == null) continue;
            component.setShipment(shipmentReference);
        }
        for (EntityReference prepaymentDocument : prepaymentDocuments) {
            EntityContainer prepaymentDocumentContainer = EntityStorageHelper.resolve((EntityReference)prepaymentDocument, (EntityStorageContext)storageContext);
            if (prepaymentDocumentContainer == null) continue;
            ((FinanceDocument)prepaymentDocumentContainer.getEntity()).getRelatedShipments().add(shipmentReference);
        }
        Set productUids = billingItemsHoldersBatch.getBillingItemHolders().stream().map(item -> item.getItem().getProduct().getNestedEntityUid()).collect(Collectors.toSet());
        List<AppliedRule> appliedRules = Stream.concat(billingItemsHoldersBatch.getAppliedRules().stream(), productHoldersBatch.getAppliedRules().stream().filter(item -> productUids.contains(item.getProductUid()))).collect(Collectors.toList());
        FinanceDocumentsIbusHelper.createShipmentProductAppliedRules(appliedRules, (EntityReference<Shipment>)shipmentReference, storageContext);
    }
}

