/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.create;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRules;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ShipmentsCreateSaveChangedEntitiesProcessor
extends BaseProcessor {
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss.SSS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(MessageContext ctx) throws Exception {
        LogicalSession ls;
        boolean success;
        block28: {
            EntityStorageContext context = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
            List ctrs = EntityStorageHelper.getChangedContainers((EntityStorageContext)context);
            List ctrsToDelete = EntityStorageHelper.getDeletedContainers((EntityStorageContext)context);
            HashSet ctrsToSave = new HashSet(ctrs);
            List bfCtrs = ctrs.stream().filter(item -> item.getEntity() instanceof BookingFile).collect(Collectors.toList());
            HashSet<Object> bfCtrsToRemove = new HashSet<Object>();
            Set<Object> shipmentCtrsToRemove = new HashSet();
            if (ctrs.isEmpty() && ctrsToDelete.isEmpty()) {
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] nothing to save, skip it"), (Object[])new Object[0]));
                return;
            }
            success = false;
            ls = LogicalStorage.get().beginUnitOfWork();
            try {
                Map sessionContext = LogicalStorage.get().getSessionContext();
                sessionContext.put(IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT.name(), context);
                sessionContext.put(IBusStandardContextKeys.MESSAGE_CONTEXT.name(), ctx);
                try {
                    List fdCtrs;
                    for (Object bfCtr : bfCtrs) {
                        try {
                            bfCtr.getVersionInfo().setDataSource(ctx.getRouteId());
                            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] save entity {0}"), (Object[])new Object[]{bfCtr.toReference().toString(), bfCtr.getUid(), bfCtr.getEntityType().getName()}));
                            EntityStorage.get().save((EntityContainer)bfCtr, true);
                        }
                        catch (Exception e) {
                            bfCtrsToRemove.add(bfCtr);
                            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.FinanceShipments_processingError, (Throwable)e, (Object[])new Object[]{e.getMessage()}));
                        }
                        finally {
                            ctrsToSave.remove(bfCtr);
                        }
                    }
                    HashSet shipmentUids = new HashSet();
                    for (Object ctr : bfCtrsToRemove) {
                        BookingFile bookingFile = (BookingFile)ctr.getEntity();
                        List products = bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).collect(Collectors.toList());
                        shipmentUids.addAll(products.stream().flatMap(p -> p.getFopDetalizations().values().stream()).flatMap(item -> item.getComponents().stream()).map(FopComponent::getShipment).filter(Objects::nonNull).map(EntityReference::getUid).collect(Collectors.toSet()));
                    }
                    shipmentCtrsToRemove = ctrs.stream().filter(item -> item.getEntity() instanceof Shipment && shipmentUids.contains(item.getUid())).collect(Collectors.toSet());
                    HashSet<String> bfUids = new HashSet<String>();
                    for (EntityContainer entityContainer : shipmentCtrsToRemove) {
                        Shipment shipment = (Shipment)entityContainer.getEntity();
                        List billingItemsRef = shipment.getBillingItems();
                        Set biUids = billingItemsRef.stream().map(EntityReference::getUid).collect(Collectors.toSet());
                        ctrsToSave.removeAll(ctrs.stream().filter(item -> item.getEntity() instanceof BillingItemsList && biUids.contains(item.getUid())).collect(Collectors.toSet()));
                        List billingItems = EntityStorageHelper.resolve((List)billingItemsRef, (EntityStorageContext)context);
                        for (BillingItem billingItem : billingItems) {
                            Set componentReferences = billingItem.getFopComponents();
                            for (NestedEntityReference componentRef : componentReferences) {
                                if (bfCtrsToRemove.stream().anyMatch(bf -> bf.getUid().equals(componentRef.getUid()))) continue;
                                FopComponent component = (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)componentRef, (EntityStorageContext)context);
                                if (component != null) {
                                    component.setShipment(null);
                                }
                                bfUids.add(componentRef.getUid());
                            }
                        }
                        ctrsToSave.remove(entityContainer);
                        ctrsToSave.removeAll(ctrs.stream().filter(item -> item.getEntity() instanceof ShipmentProductAppliedRules).filter(item -> ((ShipmentProductAppliedRules)item.getEntity()).getShipment().getUid().equals(entityContainer.getUid())).collect(Collectors.toSet()));
                    }
                    ctrsToSave.addAll(bfCtrs.stream().filter(bf -> bfUids.contains(bf.getUid())).collect(Collectors.toSet()));
                    if (!shipmentCtrsToRemove.isEmpty() && !(fdCtrs = ctrs.stream().filter(item -> item.getEntity() instanceof FinanceDocument).collect(Collectors.toList())).isEmpty()) {
                        Set set = shipmentCtrsToRemove.stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
                        Set uidsToSave = ctrsToSave.stream().filter(item -> item.getEntity() instanceof Shipment).map(BaseIdentity::getUid).collect(Collectors.toSet());
                        for (EntityContainer fdCtr : fdCtrs) {
                            FinanceDocument financeDocument = (FinanceDocument)fdCtr.getEntity();
                            boolean removed = financeDocument.getRelatedShipments().removeIf(item -> set.contains(item.getUid()));
                            if (!removed || !financeDocument.getRelatedShipments().stream().noneMatch(item -> uidsToSave.contains(item.getUid()))) continue;
                            ctrsToSave.remove(fdCtr);
                        }
                    }
                    for (EntityContainer entityContainer : ctrsToSave) {
                        if (entityContainer.getEntity() instanceof BookingFile) {
                            BookingFile bookingFile = (BookingFile)entityContainer.getEntity();
                            List products = bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).collect(Collectors.toList());
                            Set uids = products.stream().flatMap(p -> p.getFopDetalizations().values().stream()).flatMap(item -> item.getComponents().stream()).map(FopComponent::getShipment).filter(Objects::nonNull).map(EntityReference::getUid).collect(Collectors.toSet());
                            if (ctrsToSave.stream().filter(item -> item.getEntity() instanceof Shipment).noneMatch(item -> uids.contains(item.getUid()))) {
                                entityContainer.getVersionInfo().setDataSource("shipments:delete");
                                EntityStorage.get().save(entityContainer, true);
                            } else {
                                entityContainer.getVersionInfo().setDataSource(ctx.getRouteId());
                                EntityStorage.get().save(entityContainer, false);
                            }
                        } else {
                            entityContainer.getVersionInfo().setDataSource(ctx.getRouteId());
                            EntityStorage.get().save(entityContainer, true);
                        }
                        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] save entity {0}"), (Object[])new Object[]{entityContainer.toReference().toString(), entityContainer.getUid(), entityContainer.getEntityType().getName()}));
                    }
                    for (EntityContainer entityContainer : ctrsToDelete) {
                        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] delete entity {0}"), (Object[])new Object[]{entityContainer.toReference().toString(), entityContainer.getUid(), entityContainer.getEntityType().getName()}));
                        EntityStorage.get().delete(entityContainer);
                    }
                }
                finally {
                    sessionContext.remove(IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT.name());
                    sessionContext.remove(IBusStandardContextKeys.MESSAGE_CONTEXT.name());
                }
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] endUnitOfWork"), (Object[])new Object[0]));
                LogicalStorage.get().endUnitOfWork(ls, true);
                success = true;
                if (bfCtrsToRemove.isEmpty()) break block28;
            }
            catch (Throwable throwable) {
                if (!bfCtrsToRemove.isEmpty()) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.FinanceDocumentsCreateTask_failedToSave, (Object[])new Object[]{bfCtrsToRemove.size(), shipmentCtrsToRemove.size()}));
                }
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] " + (success ? "save completed successfully" : "fail save")), (Object[])new Object[0]));
                LogicalStorage.get().cancelUnitOfWork(ls);
                throw throwable;
            }
            ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.FinanceDocumentsCreateTask_failedToSave, (Object[])new Object[]{bfCtrsToRemove.size(), shipmentCtrsToRemove.size()}));
        }
        ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("[" + LocalDateTime.now().format(DTF) + "] " + (success ? "save completed successfully" : "fail save")), (Object[])new Object[0]));
        LogicalStorage.get().cancelUnitOfWork(ls);
    }
}

