/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.delete;

import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ShipmentsDeleteAllowedRoutingKeyProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext context) throws Exception {
        Collection shipmentContainers = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINERS);
        List notDeletableShipments = shipmentContainers.stream().filter(ctr -> !((Shipment)ctr.getEntity()).getCorrectionShipments().isEmpty() || !((Shipment)ctr.getEntity()).getPaymentItems().isEmpty()).collect(Collectors.toList());
        if (!notDeletableShipments.isEmpty()) {
            String numbers = notDeletableShipments.stream().map(ctr -> TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)ctr.getEntity()))).collect(Collectors.joining(", "));
            context.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.FinanceShipments_deleteShipmentCanNotDelete, (Object[])new Object[]{numbers}));
        }
        return notDeletableShipments.isEmpty() ? "YES" : "NO";
    }
}

