/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.delete;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ShipmentsDeleteUpdateFinanceDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Collection financeDocumentReferences = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES);
        EntityContainer shipmentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        NestedEntityReference billingItemReference = (NestedEntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_REFERENCE);
        List vendorDatas = (List)context.getObject((Enum)IBusFinanceContextKeys.VENDOR_DATA_LIST);
        EntityContainer financeDocumentContainer = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        if (financeDocumentContainer == null) {
            return;
        }
        FinanceDocument document = (FinanceDocument)financeDocumentContainer.getEntity();
        VendorFinanceDocumentData vendorFinanceDocumentData = document.getVendorFinanceDocumentData();
        EntityReference vendor = document.getVendor();
        if (document.isVendorDocument() && vendorDatas != null) {
            vendorDatas.stream().filter(item -> item.getVendor().equals((Object)vendor)).filter(item -> item.getVendorFinanceDocumentData().getType() == vendorFinanceDocumentData.getType() && item.getVendorFinanceDocumentData().getVendorNumber().equals(vendorFinanceDocumentData.getVendorNumber()) && MiscUtil.compare((Date)item.getVendorFinanceDocumentData().getVendorDate(), (Date)vendorFinanceDocumentData.getVendorDate()) == 0).forEach(item -> {
                item.getVendorFinanceDocumentData().setNumber(null);
                item.getVendorFinanceDocumentData().setDate(null);
                item.getVendorFinanceDocumentData().setSequenceNumber(null);
            });
        }
        document.getRelatedShipments().remove(shipmentContainer.toReference());
        if (document.getBillingItems().contains(billingItemReference)) {
            document.getBillingItems().remove(billingItemReference);
            if (!financeDocumentReferences.contains(financeDocumentContainer.toReference())) {
                financeDocumentReferences.add(financeDocumentContainer.toReference());
            }
        }
        if (document.getBillingItems().size() == 0) {
            ((Shipment)shipmentContainer.getEntity()).getFinanceDocuments().remove(financeDocumentContainer.toReference());
            financeDocumentReferences.remove(financeDocumentContainer.toReference());
            EntityStorageHelper.deleteContainer((EntityContainer)financeDocumentContainer, (EntityStorageContext)storageContext);
        }
    }
}

