/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.delete;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.ArrayList;
import java.util.Set;

public class ShipmentsDeleteUpdateProductProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        NestedEntityReference billingItemReference = (NestedEntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_REFERENCE);
        EntityContainer billingItemsListContainer = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.BILLING_ITEMS_LIST_CONTAINER);
        if (billingItemsListContainer == null) {
            return;
        }
        ArrayList vendorDatas = new ArrayList();
        EntityContainer shipmentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        BillingItem billingItem = ((BillingItemsList)billingItemsListContainer.getEntity()).getData().stream().filter(item -> item.getUid().equals(billingItemReference.getNestedEntityUid())).findFirst().orElse(null);
        if (billingItem != null) {
            Set componentReferences = billingItem.getFopComponents();
            for (NestedEntityReference componentReference : componentReferences) {
                EntityReference supplier;
                BaseProduct product;
                FopComponent component = (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)componentReference, (EntityStorageContext)storageContext);
                if (component != null) {
                    Shipment shipment = (Shipment)shipmentContainer.getEntity();
                    if (shipment.isCorrection()) {
                        component.setCorrectionShipment(null);
                    } else {
                        component.setShipment(null);
                    }
                }
                if ((product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext)) == null || (supplier = GeneralProductHelper.getSupplier((BaseProduct)product)) == null || product.getVendorFinanceDocumentsData() == null) continue;
                product.getVendorFinanceDocumentsData().stream().filter(item -> item.getType() != null && TextUtil.nonBlank((String)item.getVendorNumber()) && item.getVendorDate() != null).forEach(item -> vendorDatas.add(new FinanceDocumentsIbusHelper.VendorData((EntityReference<Organization>)supplier, (VendorFinanceDocumentData)item)));
            }
        }
        context.putObject((Enum)IBusFinanceContextKeys.VENDOR_DATA_LIST, vendorDatas);
    }
}

