/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.detach;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.stream.Collectors;

public class ShipmentsDetachProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference financeDocumentReference = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE);
        EntityContainer financeDocumentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        Collection shipmentReferences = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_REFERENCES);
        Collection shipmentContainers = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINERS);
        FinanceDocument financeDocument = (FinanceDocument)financeDocumentContainer.getEntity();
        shipmentContainers.forEach(shipmentCtr -> ((Shipment)shipmentCtr.getEntity()).getFinanceDocuments().remove(financeDocumentReference));
        financeDocument.getBillingItems().removeAll(shipmentContainers.stream().map(EntityContainer::getEntity).map(Shipment::getBillingItems).flatMap(Collection::stream).collect(Collectors.toList()));
        financeDocument.getRelatedShipments().removeAll(shipmentReferences);
    }
}

