/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.products.exclude;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ShipmentsProductsExcludeUpdateProductProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Map.Entry productBatch = (Map.Entry)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_BATCH);
        BaseProduct product = (BaseProduct)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT);
        Collection shipmentReferences = (Collection)productBatch.getValue();
        Set shipmentReferencesToUpdate = (Set)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_REFERENCES_TO_UPDATE_APPLIED_RULES);
        List fopComponents = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).collect(Collectors.toList());
        for (FopComponent fopComponent : fopComponents) {
            if (shipmentReferences.contains(fopComponent.getShipment())) {
                shipmentReferencesToUpdate.add(fopComponent.getShipment());
                fopComponent.setShipment(null);
            }
            if (!shipmentReferences.contains(fopComponent.getCorrectionShipment())) continue;
            shipmentReferencesToUpdate.add(fopComponent.getShipment());
            fopComponent.setCorrectionShipment(null);
        }
        for (EntityReference prepaymentDocumentRef : product.getPrepaymentDocuments()) {
            EntityContainer prepaymentDocument = EntityStorageHelper.resolve((EntityReference)prepaymentDocumentRef, (EntityStorageContext)storageContext);
            if (prepaymentDocument == null) continue;
            ((FinanceDocument)prepaymentDocument.getEntity()).getRelatedShipments().stream().filter(shipmentReferences::contains).map(item -> EntityStorageHelper.resolve((EntityReference)item, (EntityStorageContext)storageContext)).filter(Objects::nonNull).forEach(item -> ((Shipment)item.getEntity()).getPrepaymentFinanceDocuments().remove(prepaymentDocumentRef));
            ((FinanceDocument)prepaymentDocument.getEntity()).getRelatedShipments().removeIf(shipmentReferences::contains);
        }
        ArrayList vendorDatas = new ArrayList();
        EntityReference supplier = GeneralProductHelper.getSupplier((BaseProduct)product);
        if (supplier != null && product.getVendorFinanceDocumentsData() != null) {
            product.getVendorFinanceDocumentsData().stream().filter(item -> item.getType() != null && TextUtil.nonBlank((String)item.getVendorNumber()) && item.getVendorDate() != null).forEach(item -> vendorDatas.add(new FinanceDocumentsIbusHelper.VendorData((EntityReference<Organization>)supplier, (VendorFinanceDocumentData)item)));
        }
        context.putObject((Enum)IBusFinanceContextKeys.VENDOR_DATA_LIST, vendorDatas);
    }
}

