/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.products.exclude;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.rules.ShipmentsDateRulesHelper;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ShipmentsProductsExcludeUpdateShipmentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        boolean removeEmptyShipment = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.REMOVE_EMPTY_SHIPMENT);
        EntityContainer shipmentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        NestedEntityReference billingItemReference = (NestedEntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_REFERENCE);
        Shipment shipment = (Shipment)shipmentContainer.getEntity();
        shipment.getBillingItems().remove(billingItemReference);
        Date periodBegin = null;
        Date periodEnd = null;
        Set<BaseProduct> products = FinanceDocumentHelper.getBillingItems(shipment.getBillingItems(), storageContext).stream().map(item -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.getProduct(), (EntityStorageContext)storageContext)).filter(Objects::nonNull).collect(Collectors.toSet());
        NestedEntityReference contract = shipment.getContract();
        EntityContainer contractContainer = EntityStorageHelper.resolve((EntityReference)contract, (EntityStorageContext)storageContext);
        if (contractContainer != null) {
            periodBegin = (Date)ShipmentsDateRulesHelper.getShipmentPeriod(products, (EntityContainer<Contract>)contractContainer).getFirst();
            periodEnd = (Date)ShipmentsDateRulesHelper.getShipmentPeriod(products, (EntityContainer<Contract>)contractContainer).getLast();
        }
        List dates = products.stream().map(item -> ProductHandler.of((BaseProduct)item).findIssueDate(item)).collect(Collectors.toList());
        if (periodBegin == null) {
            periodBegin = dates.stream().reduce((xva$0, xva$1) -> MiscUtil.minimum((Date[])new Date[]{xva$0, xva$1})).orElse(null);
        }
        if (periodEnd == null) {
            periodEnd = dates.stream().reduce((xva$0, xva$1) -> MiscUtil.maximum((Date[])new Date[]{xva$0, xva$1})).orElse(null);
        }
        shipment.setPeriodBegin(periodBegin);
        shipment.setPeriodEnd(periodEnd);
        if (removeEmptyShipment && ((Shipment)shipmentContainer.getEntity()).getBillingItems().isEmpty()) {
            EntityStorageHelper.deleteContainer((EntityContainer)shipmentContainer, (EntityStorageContext)storageContext);
        }
    }
}

