/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.products.include;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ShipmentsProductsIncludeAddFinalMessagesProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Collection productReferences = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_REFERENCES);
        Collection usedBillingItemHoldersBatches = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.USED_BILLING_ITEM_HOLDERS_BATCHES);
        List mismatchedParameters = (List)context.getMandatoryObject((Enum)IBusFinanceContextKeys.MISMATCHED_PARAMETERS);
        Set addedProducts = usedBillingItemHoldersBatches.stream().flatMap(batch -> batch.getBillingItemHolders().stream()).map(BillingItemHolder::getItem).map(item -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.getProduct(), (EntityStorageContext)storageContext)).filter(Objects::nonNull).collect(Collectors.toSet());
        for (NestedEntityReference productReference : productReferences) {
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productReference, (EntityStorageContext)storageContext);
            if (addedProducts.contains(product)) continue;
            MessageType messageType = addedProducts.isEmpty() ? MessageType.ERROR : MessageType.WARNING;
            String productTitle = product != null ? GeneralProductHelper.getSystemNumber((BaseProduct)product) : "?";
            String message = mismatchedParameters.stream().filter(item -> item.getProducts().contains(product)).map(item -> item.getParameterName() + ":\n" + L10nResourcesManager.getStr((String)"FinanceShipments_requiredValue", (Object[])new Object[0]) + " - " + item.getRequiredValue() + "\n" + L10nResourcesManager.getStr((String)"FinanceShipments_currentValue", (Object[])new Object[0]) + " - " + item.getCurrentValue()).collect(Collectors.joining("\n"));
            context.addMessage(MessagesHelper.createMessage((MessageType)messageType, (String)Messages.FinanceShipments_includeProductsIsNotIncluded, (Object[])new Object[]{productTitle, TextUtil.nonBlank((String)message) ? "\n" + message : ""}));
        }
    }
}

