/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.products.include;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.BillingItemHoldersBatch;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ShipmentsProductsIncludeAddMessageProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        BillingItemHoldersBatch billingItemsHoldersBatch = (BillingItemHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDERS_BATCH);
        List mismatchedParameters = (List)context.getMandatoryObject((Enum)IBusFinanceContextKeys.MISMATCHED_PARAMETERS);
        Collection shipmentsBatches = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCHES);
        Set products = billingItemsHoldersBatch.getBillingItemHolders().stream().map(BillingItemHolder::getItem).map(item -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.getProduct(), (EntityStorageContext)storageContext)).filter(Objects::nonNull).collect(Collectors.toSet());
        for (FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch : shipmentsBatches) {
            FinanceDocumentsIbusHelper.MismatchedParameter mismatchedParameter = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_categories", (Object[])new Object[0]), shipmentsBatch.getCategories().stream().sorted((c1, c2) -> MiscUtil.compare((Comparable)((Object)c1.getCaption()), (Comparable)((Object)c2.getCaption()))).map(item -> TextUtil.nonBlank((String)item.getCaption()) ? item.getCaption() : item.getCode()).collect(Collectors.joining(", ")), billingItemsHoldersBatch.getCategories().stream().sorted((c1, c2) -> MiscUtil.compare((Comparable)((Object)c1.getCaption()), (Comparable)((Object)c2.getCaption()))).map(item -> TextUtil.nonBlank((String)item.getCaption()) ? item.getCaption() : item.getCode()).collect(Collectors.joining(", ")));
            mismatchedParameter.getProducts().addAll(products);
            mismatchedParameters.add(mismatchedParameter);
        }
    }
}

