/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.products.include;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ShipmentsProductsIncludeSearchFinanceDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch = (FinanceDocumentsIbusHelper.ShipmentsBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCH);
        FinanceDocumentsIbusHelper.ShipmentHoldersBatch shipmentHoldersBatch = (FinanceDocumentsIbusHelper.ShipmentHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDERS_BATCH);
        FinanceDocumentType type = shipmentHoldersBatch.getType();
        EntityReference<TemplateDocument> template = shipmentHoldersBatch.getTemplate();
        BillingItemIncludeMode billingItemIncludeMode = shipmentHoldersBatch.getBillingItemIncludeMode();
        VatViewMode vatViewMode = shipmentHoldersBatch.getVatViewMode();
        boolean groupByTraveller = shipmentHoldersBatch.isGroupByTraveller();
        boolean notGroupByProduct = shipmentHoldersBatch.isNotGroupByProduct();
        Boolean mergeBillingItems = shipmentHoldersBatch.getMergeBillingItems();
        boolean notGroupByServiceType = shipmentHoldersBatch.isNotGroupByServiceType();
        boolean invertSign = shipmentHoldersBatch.isInvertSign();
        boolean vendorDocument = shipmentHoldersBatch.isVendorDocument();
        UniversalDocumentStatus universalDocumentStatus = shipmentHoldersBatch.getUniversalDocumentStatus();
        List<EntityContainer<Shipment>> shipmentContainers = shipmentsBatch.getShipments();
        Set financeDocumentContainers = shipmentContainers.stream().flatMap(item -> ((Shipment)item.getEntity()).getFinanceDocuments().stream()).map(item -> EntityStorageHelper.resolve((EntityReference)item, (EntityStorageContext)storageContext)).filter(item -> item != null).collect(Collectors.toSet());
        EntityContainer searchFinanceDocumentContainer = null;
        for (EntityContainer financeDocumentContainer : financeDocumentContainers) {
            FinanceDocument financeDocument = (FinanceDocument)financeDocumentContainer.getEntity();
            if (!MiscUtil.equals((Object)financeDocument.getType(), (Object)type) || !MiscUtil.equals((Object)financeDocument.getTemplate(), template) || !MiscUtil.equals((Object)financeDocument.getBillingItemIncludeMode(), (Object)billingItemIncludeMode) || !MiscUtil.equals((Object)financeDocument.getVatViewMode(), (Object)vatViewMode) || financeDocument.isGroupByTraveller() != groupByTraveller || financeDocument.isNotGroupByProduct() != notGroupByProduct || financeDocument.getMergeBillingItems() != null && mergeBillingItems != null && !financeDocument.getMergeBillingItems().equals(mergeBillingItems) || financeDocument.isNotGroupByServiceType() != notGroupByServiceType || financeDocument.isInvertSign() != invertSign || financeDocument.isVendorDocument() != vendorDocument || financeDocument.getUniversalDocumentStatus() != universalDocumentStatus) continue;
            if (!vendorDocument) {
                searchFinanceDocumentContainer = financeDocumentContainer;
                break;
            }
            if (financeDocument.getVendor() == null || !financeDocument.getVendor().equals(shipmentHoldersBatch.getVendor()) || financeDocument.getVendorFinanceDocumentData() == null || !financeDocument.getVendorFinanceDocumentData().getType().equals((Object)shipmentHoldersBatch.getVendorFinanceDocumentData().getType()) || !financeDocument.getVendorFinanceDocumentData().getVendorNumber().equals(shipmentHoldersBatch.getVendorFinanceDocumentData().getVendorNumber()) || MiscUtil.compare((Date)financeDocument.getVendorFinanceDocumentData().getVendorDate(), (Date)shipmentHoldersBatch.getVendorFinanceDocumentData().getVendorDate()) != 0) continue;
            searchFinanceDocumentContainer = financeDocumentContainer;
            break;
        }
        context.putObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER, searchFinanceDocumentContainer);
    }
}

