/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.products.include;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.model.ibus.finance.documents.BillingItemHoldersBatch;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import com.gridnine.xtrip.server.model.ibus.finance.shipments.ShipmentsIbusHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ShipmentsProductsIncludeSearchShipmentsBatchProcessor
extends BaseProcessor {
    private boolean unused = false;

    public void configure(Map<String, String> parameters) {
        if (parameters.containsKey("unused-billingItemsHoldersBatch")) {
            this.unused = Boolean.parseBoolean(parameters.get("unused-billingItemsHoldersBatch"));
        }
    }

    public void process(MessageContext context) throws Exception {
        FinanceDocumentsIbusHelper.ProductHoldersBatch productHoldersBatch = (FinanceDocumentsIbusHelper.ProductHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDERS_BATCH);
        List mismatchedParameters = (List)context.getMandatoryObject((Enum)IBusFinanceContextKeys.MISMATCHED_PARAMETERS);
        EntityReference<Organization> supplier = productHoldersBatch.getSupplier();
        EntityReference<Organization> customer = productHoldersBatch.getCustomer();
        EntityReference<Organization> payer = productHoldersBatch.getPayer();
        EntityReference<Contract> contract = productHoldersBatch.getContract();
        DictionaryReference<CurrencyInfo> currency = productHoldersBatch.getCurrency();
        Collection shipmentsBatches = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCHES);
        BillingItemHoldersBatch billingItemsHoldersBatch = (BillingItemHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDERS_BATCH);
        EntityReference<BookingFile> bookingFile = billingItemsHoldersBatch.getBookingFile();
        NestedEntityReference<BookingFile, BaseProduct> product = billingItemsHoldersBatch.getProduct();
        EntityReference<Person> agent = billingItemsHoldersBatch.getAgent();
        Date periodBegin = billingItemsHoldersBatch.getPeriodBegin();
        Date periodEnd = billingItemsHoldersBatch.getPeriodEnd();
        String paymentCode = billingItemsHoldersBatch.getPaymentCode();
        List<CostCode> costCodes = billingItemsHoldersBatch.getCostCodes();
        Set<DictionaryReference<ShipmentCategory>> categories = billingItemsHoldersBatch.getCategories();
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        FinanceDocumentsIbusHelper.ShipmentsBatch searchShipmentBatch = null;
        ArrayList<FinanceDocumentsIbusHelper.MismatchedParameter> parameters = new ArrayList<FinanceDocumentsIbusHelper.MismatchedParameter>();
        for (FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch : shipmentsBatches) {
            if (this.unused && shipmentsBatch.getShipments().stream().allMatch(c -> ((Shipment)c.getEntity()).getBillingItems().isEmpty())) {
                StringBuilder name = new StringBuilder();
                for (DictionaryReference<ShipmentCategory> category : billingItemsHoldersBatch.getCategories()) {
                    if (name.length() > 0) {
                        name.append(" ");
                    }
                    name.append(category);
                }
                Collection<BillingItemHolder> billingItemHolders = billingItemsHoldersBatch.getBillingItemHolders();
                String bookingFileNumbers = billingItemHolders.stream().map(item -> EntityStorageHelper.getContainer((EntityStorageContext)storageContext, (EntityReference)item.getItem().getProduct()).toReference()).distinct().map(item -> item.toString()).sorted().collect(Collectors.joining(", "));
                if (!TextUtil.isBlank((String)bookingFileNumbers)) {
                    if (name.length() > 0) {
                        name.append(" ");
                    }
                    name.append(bookingFileNumbers);
                }
                for (EntityContainer<Shipment> shipmentCtr : shipmentsBatch.getShipments()) {
                    Shipment shipment = (Shipment)shipmentCtr.getEntity();
                    shipment.setName(name.toString());
                    shipment.setSupplier(supplier);
                    shipment.setCustomer(customer);
                    if (billingItemsHoldersBatch.isUseTravellerAsPayer() && ProfileHelper.isRetailProfile(payer)) {
                        EntityReference<Organization> traveller = billingItemHolders.stream().map(item -> (Traveller)EntityStorageHelper.resolve((NestedEntityReference)item.getItem().getTraveller(), (EntityStorageContext)storageContext)).filter(Objects::nonNull).map(Traveller::getPassenger).filter(Objects::nonNull).findFirst().orElse(null);
                        shipment.setPayer(traveller != null ? traveller : payer);
                    } else {
                        shipment.setPayer(payer);
                    }
                    shipment.setContract(ShipmentsIbusHelper.createContractReference(contract));
                    shipment.setCurrency(currency);
                    shipment.setAgent(ProfileHelper.getCurrentUser());
                    shipment.setPeriodBegin(null);
                    shipment.setPeriodEnd(null);
                    shipment.setCategoryBookingFile(billingItemsHoldersBatch.getBookingFile());
                    shipment.setCategoryProduct(billingItemsHoldersBatch.getProduct());
                    shipment.setCategoryAgent(billingItemsHoldersBatch.getAgent());
                    shipment.setCategoryPeriodBegin(billingItemsHoldersBatch.getPeriodBegin());
                    shipment.setCategoryPeriodEnd(billingItemsHoldersBatch.getPeriodEnd());
                    shipment.setCategoryPaymentCode(billingItemsHoldersBatch.getPaymentCode());
                    shipment.getCostCodes().clear();
                    shipment.getCostCodes().addAll(billingItemsHoldersBatch.getCostCodes());
                    shipment.getCategories().clear();
                    shipment.getCategories().addAll(billingItemsHoldersBatch.getCategories());
                }
                shipmentsBatch.setSupplier(supplier);
                shipmentsBatch.setCustomer(customer);
                shipmentsBatch.setPayer(payer);
                shipmentsBatch.setContract(contract);
                shipmentsBatch.setCurrency(currency);
                shipmentsBatch.setBookingFile(bookingFile);
                shipmentsBatch.setProduct(product);
                shipmentsBatch.setAgent(agent);
                shipmentsBatch.setPeriodBegin(periodBegin);
                shipmentsBatch.setPeriodEnd(periodEnd);
                shipmentsBatch.setPaymentCode(paymentCode);
                shipmentsBatch.getCostCodes().clear();
                shipmentsBatch.getCostCodes().addAll(costCodes);
                shipmentsBatch.getCategories().clear();
                shipmentsBatch.getCategories().addAll(categories);
                searchShipmentBatch = shipmentsBatch;
                break;
            }
            if (this.unused || !this.isMatchesParameters(shipmentsBatch, productHoldersBatch, billingItemsHoldersBatch, parameters, storageContext)) continue;
            searchShipmentBatch = shipmentsBatch;
            break;
        }
        if (searchShipmentBatch == null) {
            mismatchedParameters.addAll(parameters);
        }
        context.putObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCH, searchShipmentBatch);
    }

    private boolean isMatchesParameters(FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch, FinanceDocumentsIbusHelper.ProductHoldersBatch productHoldersBatch, BillingItemHoldersBatch billingItemsHoldersBatch, List<FinanceDocumentsIbusHelper.MismatchedParameter> mismatchedParameters, EntityStorageContext storageContext) {
        FinanceDocumentsIbusHelper.MismatchedParameter mismatchedParameter;
        FinanceDocumentsIbusHelper.MismatchedParameter mismatchedParameter2;
        boolean result = true;
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        EntityReference<Organization> supplier = productHoldersBatch.getSupplier();
        EntityReference<Organization> customer = productHoldersBatch.getCustomer();
        EntityReference<Organization> payer = null;
        if (productHoldersBatch.getPayer() != null) {
            payer = ShipmentHelper.getPayerOrganization(productHoldersBatch.getPayer());
        }
        EntityReference<Contract> contract = productHoldersBatch.getContract();
        DictionaryReference<CurrencyInfo> currency = productHoldersBatch.getCurrency();
        Set<DictionaryReference<ShipmentCategory>> categories = billingItemsHoldersBatch.getCategories();
        EntityReference<BookingFile> bookingFile = billingItemsHoldersBatch.getBookingFile();
        NestedEntityReference<BookingFile, BaseProduct> productReference = billingItemsHoldersBatch.getProduct();
        EntityReference<Person> agent = billingItemsHoldersBatch.getAgent();
        Date periodBegin = billingItemsHoldersBatch.getPeriodBegin();
        Date periodEnd = billingItemsHoldersBatch.getPeriodEnd();
        String paymentCode = billingItemsHoldersBatch.getPaymentCode();
        List<CostCode> costCodes = billingItemsHoldersBatch.getCostCodes();
        Set currentCostCodes = costCodes.stream().filter(cc -> cc.getCostCodeProperties() != null).map(cc -> cc.getCostCodeProperties().getUid() + ":" + cc.getValue()).collect(Collectors.toSet());
        EntityReference<Organization> requiredSupplier = shipmentsBatch.getSupplier();
        EntityReference<Organization> requiredCustomer = shipmentsBatch.getCustomer();
        EntityReference<Organization> requiredPayer = null;
        if (shipmentsBatch.getPayer() != null) {
            requiredPayer = ShipmentHelper.getPayerOrganization(shipmentsBatch.getPayer());
        }
        EntityReference<Contract> requiredContract = shipmentsBatch.getContract();
        DictionaryReference<CurrencyInfo> requiredCurrency = shipmentsBatch.getCurrency();
        Set<DictionaryReference<ShipmentCategory>> requiredCategories = shipmentsBatch.getCategories();
        EntityReference<BookingFile> requiredBookingFile = shipmentsBatch.getBookingFile();
        NestedEntityReference<BookingFile, BaseProduct> requiredProductReference = shipmentsBatch.getProduct();
        EntityReference<Person> requiredAgent = shipmentsBatch.getAgent();
        Date requiredPeriodBegin = shipmentsBatch.getPeriodBegin();
        Date requiredPeriodEnd = shipmentsBatch.getPeriodEnd();
        String requiredPaymentCode = shipmentsBatch.getPaymentCode();
        Set requiredCostCodes = shipmentsBatch.getCostCodes().stream().filter(cc -> cc.getCostCodeProperties() != null).map(cc -> cc.getCostCodeProperties().getUid() + ":" + cc.getValue()).collect(Collectors.toSet());
        Set products = billingItemsHoldersBatch.getBillingItemHolders().stream().map(BillingItemHolder::getItem).map(item -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.getProduct(), (EntityStorageContext)storageContext)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!MiscUtil.equals(requiredSupplier, supplier)) {
            mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_supplier", (Object[])new Object[0]), requiredSupplier != null ? requiredSupplier.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]), supplier != null ? supplier.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            mismatchedParameters.add(mismatchedParameter2);
            result = false;
        }
        if (!MiscUtil.equals(requiredCustomer, customer)) {
            mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_customer", (Object[])new Object[0]), requiredCustomer != null ? requiredCustomer.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]), customer != null ? customer.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            mismatchedParameters.add(mismatchedParameter2);
            result = false;
        }
        if (!MiscUtil.equals(requiredPayer, payer)) {
            mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_payer", (Object[])new Object[0]), requiredPayer != null ? requiredPayer.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]), payer != null ? payer.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            mismatchedParameters.add(mismatchedParameter2);
            result = false;
        }
        if (!MiscUtil.equals(requiredContract, contract)) {
            EntityContainer contractCtr = null;
            EntityContainer requiredContractCtr = null;
            if (contract != null) {
                contractCtr = EntityStorageHelper.resolve(contract, (EntityStorageContext)storageContext);
            }
            if (requiredContract != null) {
                requiredContractCtr = EntityStorageHelper.resolve(requiredContract, (EntityStorageContext)storageContext);
            }
            mismatchedParameter = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_contract", (Object[])new Object[0]), requiredContractCtr != null ? ((Contract)requiredContractCtr.getEntity()).getName() + " " + ((Contract)requiredContractCtr.getEntity()).getNumber() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]), contractCtr != null ? ((Contract)contractCtr.getEntity()).getName() + " " + ((Contract)contractCtr.getEntity()).getNumber() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            mismatchedParameters.add(mismatchedParameter);
            result = false;
        }
        if (!MiscUtil.equals(requiredCurrency, currency)) {
            mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_currency", (Object[])new Object[0]), requiredCurrency != null ? requiredCurrency.getCode() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]), currency != null ? currency.getCode() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            mismatchedParameters.add(mismatchedParameter2);
            result = false;
        }
        if (!MiscUtil.equals(requiredCategories, categories)) {
            mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_categories", (Object[])new Object[0]), requiredCategories.stream().sorted((c1, c2) -> MiscUtil.compare((Comparable)((Object)c1.getCaption()), (Comparable)((Object)c2.getCaption()))).map(item -> TextUtil.nonBlank((String)item.getCaption()) ? item.getCaption() : item.getCode()).collect(Collectors.joining(", ")), categories.stream().sorted((c1, c2) -> MiscUtil.compare((Comparable)((Object)c1.getCaption()), (Comparable)((Object)c2.getCaption()))).map(item -> TextUtil.nonBlank((String)item.getCaption()) ? item.getCaption() : item.getCode()).collect(Collectors.joining(", ")));
            mismatchedParameters.add(mismatchedParameter2);
            result = false;
        }
        if (!MiscUtil.equals(requiredBookingFile, bookingFile)) {
            mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_categoryBookingFile", (Object[])new Object[0]), requiredBookingFile != null ? requiredBookingFile.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]), bookingFile != null ? bookingFile.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            mismatchedParameters.add(mismatchedParameter2);
            result = false;
        }
        if (!MiscUtil.equals(requiredProductReference, productReference)) {
            BaseProduct requiredProduct = (BaseProduct)EntityStorageHelper.resolve(requiredProductReference, (EntityStorageContext)storageContext);
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve(productReference, (EntityStorageContext)storageContext);
            mismatchedParameter = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_categoryProduct", (Object[])new Object[0]), requiredProduct != null ? GeneralProductHelper.getSystemNumber((BaseProduct)requiredProduct) : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]), product != null ? GeneralProductHelper.getSystemNumber((BaseProduct)product) : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            mismatchedParameters.add(mismatchedParameter);
            result = false;
        }
        if (!MiscUtil.equals(requiredAgent, agent)) {
            mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_categoryAgent", (Object[])new Object[0]), requiredAgent != null ? requiredAgent.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]), agent != null ? agent.getCaption() : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            mismatchedParameters.add(mismatchedParameter2);
            result = false;
        }
        if (!MiscUtil.equals((Object)requiredPeriodBegin, (Object)periodBegin)) {
            mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_periodBegin", (Object[])new Object[0]), requiredPeriodBegin != null ? format.format(requiredPeriodBegin) : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]), periodBegin != null ? format.format(periodBegin) : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            mismatchedParameters.add(mismatchedParameter2);
            result = false;
        }
        if (!MiscUtil.equals((Object)requiredPeriodEnd, (Object)periodEnd)) {
            mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_periodEnd", (Object[])new Object[0]), requiredPeriodEnd != null ? format.format(requiredPeriodEnd) : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]), periodEnd != null ? format.format(periodEnd) : L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            mismatchedParameters.add(mismatchedParameter2);
            result = false;
        }
        if (!MiscUtil.equals((Object)requiredPaymentCode, (Object)paymentCode)) {
            mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_categoryPaymentCode", (Object[])new Object[0]), requiredPaymentCode, paymentCode);
            mismatchedParameters.add(mismatchedParameter2);
            result = false;
        }
        if (!MiscUtil.equals(requiredCostCodes, currentCostCodes)) {
            mismatchedParameter2 = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)"FinanceShipments_categoryCostCode", (Object[])new Object[0]), shipmentsBatch.getCostCodes().stream().filter(cc -> cc.getCostCodeProperties() != null).sorted((cc1, cc2) -> MiscUtil.compare((Comparable)((Object)cc1.getCostCodeProperties().getName()), (Comparable)((Object)cc2.getCostCodeProperties().getName()))).map(cc -> cc.getCostCodeProperties().getName() + ":" + cc.getValue()).collect(Collectors.joining(", ")), costCodes.stream().filter(cc -> cc.getCostCodeProperties() != null).sorted((cc1, cc2) -> MiscUtil.compare((Comparable)((Object)cc1.getCostCodeProperties().getName()), (Comparable)((Object)cc2.getCostCodeProperties().getName()))).map(cc -> cc.getCostCodeProperties().getName() + ":" + cc.getValue()).collect(Collectors.joining(", ")));
            mismatchedParameters.add(mismatchedParameter2);
            result = false;
        }
        mismatchedParameters.forEach(item -> item.getProducts().addAll(products));
        return result;
    }
}

