/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.products.include;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.ibus.finance.documents.BillingItemHoldersBatch;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ShipmentsProductsIncludeUpdateFinanceDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        BaseProduct product;
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Collection financeDocumentReferences = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES);
        EntityContainer financeDocumentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        EntityContainer billingItemsListContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEMS_LIST_CONTAINER);
        FinanceDocumentsIbusHelper.ShipmentHoldersBatch shipmentHoldersBatch = (FinanceDocumentsIbusHelper.ShipmentHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDERS_BATCH);
        BillingItemHoldersBatch billingItemsHoldersBatch = (BillingItemHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDERS_BATCH);
        boolean vendorDocument = shipmentHoldersBatch.isVendorDocument();
        VendorFinanceDocumentData vendorFinanceDocumentData = shipmentHoldersBatch.getVendorFinanceDocumentData();
        Date date = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.DATE);
        if (vendorDocument && vendorFinanceDocumentData != null && vendorFinanceDocumentData.getVendorDate() != null) {
            date = vendorFinanceDocumentData.getVendorDate();
        }
        BillingItemIncludeMode billingItemIncludeMode = shipmentHoldersBatch.getBillingItemIncludeMode();
        Collection<BillingItemHolder> billingItemHolders = billingItemsHoldersBatch.getBillingItemHolders();
        FinanceDocument financeDocument = (FinanceDocument)financeDocumentContainer.getEntity();
        boolean consolidated = FinanceDocumentsHelper.isConsolidated((FinanceDocumentType)financeDocument.getType());
        if (!consolidated && !date.equals(financeDocument.getDate())) {
            financeDocument.setDate(date);
            financeDocumentReferences.add(financeDocumentContainer.toReference());
        }
        ArrayList<BillingItem> billingItems = new ArrayList<BillingItem>();
        for (BillingItemHolder billingItemHolder : billingItemHolders) {
            EntityContainer vendorContract;
            EntityReference vendorContractRef;
            BillingItem billingItem = billingItemHolder.getItem();
            product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext);
            if (product == null) continue;
            EntityReference vendor = GeneralProductHelper.getSupplier((BaseProduct)product);
            HotelProvider hotelProvider = null;
            Double hotelVatRate = null;
            if (product instanceof HotelProduct) {
                hotelProvider = ((HotelProduct)product).getProvider();
                hotelVatRate = HotelProductHelper.getHotelVatRate((HotelProduct)((HotelProduct)product));
            }
            AgreementType agreementType = null;
            GeneralProductContractRelationData contractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product);
            if (contractRelation != null && (vendorContractRef = contractRelation.getGeneralData().getContractData().getContract()) != null && (vendorContract = EntityStorage.get().resolve(vendorContractRef)) != null) {
                agreementType = ((Contract)vendorContract.getEntity()).getAgreementType();
            }
            HotelProvider finalHotelProvider = hotelProvider;
            AgreementType finalAgreementType = agreementType;
            Double finalHotelVatRate = hotelVatRate;
            Set shipmentHolders = shipmentHoldersBatch.getShipmentHolders().stream().filter(item -> MiscUtil.equals((Object)item.getNomenclature(), (Object)billingItem.getNomenclature())).filter(item -> MiscUtil.equals((Object)item.getVendor(), (Object)vendor)).filter(item -> MiscUtil.equals((Object)item.getHotelProvider(), (Object)finalHotelProvider)).filter(item -> MiscUtil.equals((Object)item.getVendorAgreementType(), (Object)finalAgreementType)).filter(item -> MiscUtil.equals((Object)item.getHotelVatRate(), (Object)finalHotelVatRate)).collect(Collectors.toSet());
            if (shipmentHolders.isEmpty()) continue;
            if (vendorDocument && vendorFinanceDocumentData != null) {
                Set<VendorFinanceDocumentData> vendorFinanceDocumentsData = product.getVendorFinanceDocumentsData().stream().filter(item -> vendorFinanceDocumentData.getType().equals((Object)item.getType())).filter(item -> vendorFinanceDocumentData.getVendorNumber().equals(item.getVendorNumber())).filter(item -> MiscUtil.compare((Date)vendorFinanceDocumentData.getVendorDate(), (Date)item.getVendorDate()) == 0).collect(Collectors.toSet());
                if (!shipmentHoldersBatch.getVendor().equals((Object)GeneralProductHelper.getSupplier((BaseProduct)product)) || vendorFinanceDocumentsData.isEmpty()) continue;
                vendorFinanceDocumentsData.forEach(item -> {
                    item.setNumber(financeDocument.getNumber());
                    item.setDate(financeDocument.getDate());
                    if (item.getSequenceNumber() == null) {
                        item.setSequenceNumber(vendorFinanceDocumentData.getSequenceNumber());
                    }
                });
            }
            billingItems.add(billingItem);
        }
        HashMap<BaseProduct, List> billingItemsToProducts = new HashMap<BaseProduct, List>();
        for (BillingItem billingItem : billingItems) {
            product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext);
            if (product == null) continue;
            List prepaymentBillingItems = billingItemsToProducts.computeIfAbsent(product, p -> product.getPrepaymentDocuments().stream().map(item -> EntityStorageHelper.resolve((EntityReference)item, (EntityStorageContext)storageContext)).filter(Objects::nonNull).flatMap(item -> FinanceDocumentHelper.getBillingItems(((FinanceDocument)item.getEntity()).getBillingItems(), storageContext).stream()).collect(Collectors.toList()));
            if (!ProductHandler.of((BaseProduct)product).isAppropriateBillingItem(product, financeDocument.getType(), financeDocument.getUniversalDocumentStatus(), billingItemIncludeMode, billingItem, billingItems, prepaymentBillingItems)) continue;
            financeDocument.getBillingItems().add(new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem));
            if (financeDocumentReferences.contains(financeDocumentContainer.toReference())) continue;
            financeDocumentReferences.add(financeDocumentContainer.toReference());
        }
    }
}

