/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.products.include;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.rules.ShipmentsDateRulesHelper;
import com.gridnine.xtrip.server.model.ibus.finance.documents.BillingItemHoldersBatch;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ShipmentsProductsIncludeUpdateShipmentsProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        BillingItemHoldersBatch billingItemsHoldersBatch = (BillingItemHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDERS_BATCH);
        FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch = (FinanceDocumentsIbusHelper.ShipmentsBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCH);
        EntityContainer billingItemsListContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEMS_LIST_CONTAINER);
        FinanceDocumentsIbusHelper.ProductHoldersBatch productHoldersBatch = (FinanceDocumentsIbusHelper.ProductHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDERS_BATCH);
        Map appliedRulesMap = (Map)context.getObject((Enum)IBusFinanceContextKeys.SHIPMENT_APPLIED_RULES);
        Date date = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.DATE);
        Collection<BillingItemHolder> billingItemHolders = billingItemsHoldersBatch.getBillingItemHolders();
        List billingItemsList = billingItemHolders.stream().map(item -> new NestedEntityReference(billingItemsListContainer, (BaseEntity)item.getItem())).collect(Collectors.toList());
        context.putObject((Enum)IBusFinanceContextKeys.BILLING_ITEMS_LIST_TO_INCLUDE, billingItemsList);
        List<EntityContainer<Shipment>> shipmentContainers = shipmentsBatch.getShipments();
        for (EntityContainer<Shipment> shipmentContainer : shipmentContainers) {
            Object billigItem2;
            Shipment shipment = (Shipment)shipmentContainer.getEntity();
            shipment.getBillingItems().addAll(billingItemsList);
            shipment.setDate(date);
            Date periodBegin = null;
            Date periodEnd = null;
            Set<BaseProduct> products = FinanceDocumentsIbusHelper.getProductsFromBillingItemsList(shipment.getBillingItems(), null, null, storageContext);
            NestedEntityReference contract = shipment.getContract();
            EntityContainer contractContainer = EntityStorageHelper.resolve((EntityReference)contract, (EntityStorageContext)storageContext);
            if (contractContainer != null) {
                periodBegin = (Date)ShipmentsDateRulesHelper.getShipmentPeriod(products, (EntityContainer<Contract>)contractContainer).getFirst();
                periodEnd = (Date)ShipmentsDateRulesHelper.getShipmentPeriod(products, (EntityContainer<Contract>)contractContainer).getLast();
            }
            List dates = products.stream().map(item -> ProductHandler.of((BaseProduct)item).findIssueDate(item)).collect(Collectors.toList());
            if (periodBegin == null) {
                periodBegin = dates.stream().reduce((xva$0, xva$1) -> MiscUtil.minimum((Date[])new Date[]{xva$0, xva$1})).orElse(null);
            }
            if (periodEnd == null) {
                periodEnd = dates.stream().reduce((xva$0, xva$1) -> MiscUtil.maximum((Date[])new Date[]{xva$0, xva$1})).orElse(null);
            }
            shipment.setPeriodBegin(periodBegin);
            shipment.setPeriodEnd(periodEnd);
            for (Object billigItem2 : billingItemHolders.stream().map(item -> item.getItem()).collect(Collectors.toList())) {
                billigItem2.setShipment(shipmentContainer.toReference());
            }
            List componentReferences = billingItemHolders.stream().flatMap(item -> item.getItem().getFopComponents().stream()).collect(Collectors.toList());
            billigItem2 = componentReferences.iterator();
            while (billigItem2.hasNext()) {
                NestedEntityReference componentReference = (NestedEntityReference)billigItem2.next();
                FopComponent component = (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)componentReference, (EntityStorageContext)storageContext);
                if (component == null) continue;
                if (((Shipment)shipmentContainer.getEntity()).isCorrection()) {
                    component.setCorrectionShipment(shipmentContainer.toReference());
                    continue;
                }
                component.setShipment(shipmentContainer.toReference());
            }
            Set productUids = billingItemsHoldersBatch.getBillingItemHolders().stream().map(item -> item.getItem().getProduct().getNestedEntityUid()).collect(Collectors.toSet());
            List appliedRules = appliedRulesMap.computeIfAbsent(shipmentContainer.toReference(), k -> new ArrayList());
            appliedRules.addAll(Stream.concat(billingItemsHoldersBatch.getAppliedRules().stream(), productHoldersBatch.getAppliedRules().stream().filter(item -> productUids.contains(item.getProductUid()))).collect(Collectors.toList()));
        }
    }
}

