/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.shipments.update;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectBillingItemProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.rules.finance.BillingItemActionSet;
import com.gridnine.xtrip.common.model.rules.finance.BillingItemPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.format.object.Format;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class ShipmentsUpdateUpdateBillingItemProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        BaseProduct product;
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer shipmentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        NestedEntityReference billingItemReference = (NestedEntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_REFERENCE);
        EntityContainer billingItemsListContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEMS_LIST_CONTAINER);
        Shipment shipment = (Shipment)shipmentContainer.getEntity();
        BillingItem billingItem = ((BillingItemsList)billingItemsListContainer.getEntity()).getData().stream().filter(item -> item.getUid().equals(billingItemReference.getNestedEntityUid())).findFirst().orElse(null);
        if (billingItem != null && (product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)storageContext)) != null) {
            String pattern;
            ProductHandler handler = ProductHandler.of((BaseProduct)product);
            ExtendedProductType productType = new ExtendedProductType();
            productType.setProductType(handler.getProductType(product));
            productType.setProductDescription(handler.getUniversalProductDescription(product));
            ProductStatus status = handler.getBaseStatus(product);
            boolean issuedInExchange = handler.getStatus(product) == ProductStatus.SELL && handler.getPreviousProduct(product) != null && handler.getStatus(handler.getPreviousProduct(product)) == ProductStatus.EXCHANGE;
            boolean refunded = false;
            BaseProduct lastProduct = handler.getNextProduct(product);
            if (lastProduct != null) {
                while (handler.getNextProduct(lastProduct) != null) {
                    lastProduct = handler.getNextProduct(lastProduct);
                }
                refunded = handler.getStatus(product) == ProductStatus.SELL && handler.getStatus(lastProduct) == ProductStatus.REFUND;
            }
            Collection additionalServices = handler.getProductEquivalentAdditionalServices(product);
            BillingItemHolder billingItemHolder = new BillingItemHolder();
            billingItemHolder.setServiceType(billingItem.getServiceType());
            billingItemHolder.setProductType(productType);
            billingItemHolder.setProductStatus(status);
            billingItemHolder.setIssuedInExchange(issuedInExchange);
            billingItemHolder.setRefunded(refunded);
            billingItemHolder.setPaymentType(billingItem.getPaymentType());
            billingItemHolder.setNomenclature(billingItem.getNomenclature());
            billingItemHolder.setTravellersCount(handler.getTravellers(product).size());
            billingItemHolder.setHasAdditionalServices(additionalServices != null && !additionalServices.isEmpty());
            billingItemHolder.setItem(billingItem);
            NestedEntityReference contract = shipment.getContract();
            Date date = new Date();
            RuleProxy proxy = new RuleProxy();
            BillingItemPropertySet propertySet = new BillingItemPropertySet(proxy);
            propertySet.init(billingItemHolder);
            BillingItemActionSet actionSet = new BillingItemActionSet();
            proxy.setProxyType(Targets.BILLING_ITEM.getId());
            proxy.setProxyDate(date);
            proxy.setPropertySet((Object)propertySet);
            proxy.setActionSet((Object)actionSet);
            EntityContainer contractContainer = EntityStorageHelper.resolve((EntityReference)contract, (EntityStorageContext)storageContext);
            if (contractContainer != null) {
                List rules = ProfileHelper.getRuleContainers((EntityContainer)contractContainer, (Date)date);
                for (EntityContainer rule : rules) {
                    RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet(), (RuleResultHandler)new RuleResultHandler(){

                        public boolean isProcessAllRuleResults() {
                            return true;
                        }

                        public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) throws Exception {
                        }
                    });
                }
            }
            String name = Format.of((String)((pattern = actionSet.getPattern()) != null ? String.format("{id=%s:%s|pattern=%s}", ModelFormatObjects.BILLING_ITEM.getId(), ModelFormatObjectBillingItemProperties.PRODUCT.getId(), pattern) : String.format("{id=%s:%s}", ModelFormatObjects.BILLING_ITEM.getId(), ModelFormatObjectBillingItemProperties.PRODUCT.getId()))).format(Format.FormatObjectDataBuilder.get().object((Object)billingItemHolder.getItem(), ModelFormatObjects.BILLING_ITEM.getId()).build(), storageContext);
            billingItem.setName(name);
        }
    }
}

