/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.transaction.data.holder;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.TransactionDataHolder;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceTransactionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class FinanceTransactionDataHolderOrganizationTransactionDatasTargetsProvider
extends BaseTargetsProvider<FinanceTransactionHelper.TransactionData> {
    public Collection<FinanceTransactionHelper.TransactionData> getTargets(MessageContext context) throws Exception {
        TransactionDataHolder transactionDataHolder = (TransactionDataHolder)context.getMandatoryObject((Enum)IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER);
        if (transactionDataHolder.getDate() == null || transactionDataHolder.getAmount() == null || transactionDataHolder.getAmount().getValue() == null || transactionDataHolder.getAmount().getCurrency() == null) {
            return Collections.emptyList();
        }
        ArrayList<FinanceTransactionHelper.TransactionData> transactionDatas = new ArrayList<FinanceTransactionHelper.TransactionData>();
        EntityReference organization = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.ORGANIZATION_REFERENCE);
        EntityContainer chartOfAccountsSettingsContainer = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.ORGANIZATION_CHART_OF_ACCOUNTS_SETTINGS_CONTAINER);
        if (chartOfAccountsSettingsContainer != null) {
            ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity();
            if (FinanceHelper.isChartOfAccountsSettingsDisabled((ChartOfAccountsSettings)chartOfAccountsSettings)) {
                return Collections.emptyList();
            }
            ChartOfAccountsElementType creditChartOfAccountsElementType = null;
            BasicChartOfAccountsElementSettings creditChartOfAccountsElementSettings = null;
            FinanceTransactionHelper.SplitData creditSplitData = null;
            ChartOfAccountsElementType debitChartOfAccountsElementType = null;
            BasicChartOfAccountsElementSettings debitChartOfAccountsElementSettings = null;
            FinanceTransactionHelper.SplitData debitSplitData = null;
            MiscUtil.Pair creditChartOfAccountsData = transactionDataHolder.getOrganizationCreditChartOfAccountElementTypes().stream().map(item -> new MiscUtil.Pair(item, (Object)FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)item))).filter(item -> item.getSecond() == null || ((BasicChartOfAccountsElementSettings)item.getSecond()).isEnabled()).findFirst().orElse(null);
            if (creditChartOfAccountsData != null) {
                creditChartOfAccountsElementType = (ChartOfAccountsElementType)creditChartOfAccountsData.getFirst();
                creditChartOfAccountsElementSettings = (BasicChartOfAccountsElementSettings)creditChartOfAccountsData.getSecond();
                creditSplitData = new FinanceTransactionHelper.SplitData();
                creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
                creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
                MiscUtil.Pair debitChartOfAccountsData = transactionDataHolder.getOrganizationDebitChartOfAccountElementTypes().stream().map(item -> new MiscUtil.Pair(item, (Object)FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)item))).filter(item -> item.getSecond() == null || ((BasicChartOfAccountsElementSettings)item.getSecond()).isEnabled()).findFirst().orElse(null);
                if (debitChartOfAccountsData != null) {
                    debitChartOfAccountsElementType = (ChartOfAccountsElementType)debitChartOfAccountsData.getFirst();
                    debitChartOfAccountsElementSettings = (BasicChartOfAccountsElementSettings)debitChartOfAccountsData.getSecond();
                    debitSplitData = new FinanceTransactionHelper.SplitData();
                    debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
                    debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
                    FinanceTransactionHelper.TransactionData transactionData = FinanceTransactionHelper.createTransactionData(transactionDataHolder, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, (EntityReference<Organization>)organization, debitSplitData, creditSplitData);
                    if (transactionData != null) {
                        transactionDatas.add(transactionData);
                    }
                }
            }
        }
        return transactionDatas;
    }
}

