/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.update.balance;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.FinanceBalancesUpdateTaskConfiguration;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class DeleteNonAuxiliaryOldRecordsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        FinanceBalancesUpdateTaskConfiguration config = (FinanceBalancesUpdateTaskConfiguration)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION);
        if (!config.isDeleteNonAuxiliaryOldRecords()) {
            this.log.debug("deleteNonAuxiliaryOldRecords is false, skipping");
            return;
        }
        Date operationDate = (Date)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.OPERATION_DATE);
        Date calculationDate = (Date)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.CALCULATION_DATE);
        SearchQuery newQuery = new SearchQuery();
        newQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.operationDate.name(), (Object)operationDate));
        newQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.calculationDate.name(), (Object)calculationDate));
        newQuery.getCriteria().getCriterions().add(SearchCriterion.ne((String)OpeningBalance.Property.auxiliary.name(), (Object)true));
        for (OpeningBalance newBalance : AssetsStorage.get().search(OpeningBalance.class, newQuery).getData()) {
            this.log.debug("deleting old records for {}/{}/{}/{}/{}", new Object[]{newBalance.getOrganizationUid(), newBalance.getAccountUid(), newBalance.getDimension1(), newBalance.getDimension2(), newBalance.getDimension3()});
            SearchQuery oldQuery = new SearchQuery();
            oldQuery.getCriteria().getCriterions().add(SearchCriterion.lt((String)OpeningBalance.Property.operationDate.name(), (Object)operationDate));
            oldQuery.getCriteria().getCriterions().add(SearchCriterion.lt((String)OpeningBalance.Property.calculationDate.name(), (Object)calculationDate));
            oldQuery.getCriteria().getCriterions().add(SearchCriterion.ne((String)OpeningBalance.Property.auxiliary.name(), (Object)true));
            oldQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.organizationUid.name(), (Object)newBalance.getOrganizationUid()));
            oldQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.accountUid.name(), (Object)newBalance.getAccountUid()));
            oldQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.dimension1.name(), (Object)newBalance.getDimension1()));
            oldQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.dimension2.name(), (Object)newBalance.getDimension2()));
            oldQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)OpeningBalance.Property.dimension3.name(), (Object)newBalance.getDimension3()));
            for (OpeningBalance oldBalance : AssetsStorage.get().search(OpeningBalance.class, oldQuery).getData()) {
                this.log.debug("deleting old record with dates {}/{}", (Object)oldBalance.getOperationDate(), (Object)oldBalance.getCalculationDate());
                AssetsStorage.get().delete((BaseAsset)oldBalance);
            }
        }
    }
}

