/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.update.balance;

import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.FinanceBalancesUpdateTaskConfiguration;
import com.gridnine.xtrip.common.model.finance.FinanceUpdateBalancesTaskData;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class FinanceUpdateBalancesCalculateOperationAndCalculationDatesProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        FinanceUpdateBalancesTaskData taskData = (FinanceUpdateBalancesTaskData)context.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_DATA);
        FinanceBalancesUpdateTaskConfiguration config = (FinanceBalancesUpdateTaskConfiguration)context.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION);
        Date operationDate = null;
        Date calculationDate = null;
        if (taskData.getOperationDate() == null || taskData.getCalculationDate() == null) {
            Date date = new Date();
            date = MiscUtil.addMinutesToDate((Date)date, (int)-1);
            date = MiscUtil.clearTime((Date)date);
            if (config.getOperationDate() != null) {
                operationDate = config.getOperationDate();
                this.log.debug(String.format("operation data %s is configured", operationDate));
            } else {
                operationDate = date;
                this.log.debug(String.format("operation data %s is calculated", operationDate));
            }
            if (config.getCalculationDate() != null) {
                calculationDate = config.getCalculationDate();
                this.log.debug(String.format("calculation data %s is configured", calculationDate));
            } else {
                calculationDate = date;
                this.log.debug(String.format("calculation data %s is calculated", calculationDate));
            }
        } else {
            operationDate = taskData.getOperationDate();
            calculationDate = taskData.getCalculationDate();
            this.log.debug(String.format("operation data %s is extracted", operationDate));
            this.log.debug(String.format("calculation data %s is extracted", calculationDate));
        }
        context.putObject((Enum)IBusFinanceContextKeys.OPERATION_DATE, (Object)operationDate);
        context.putObject((Enum)IBusFinanceContextKeys.CALCULATION_DATE, (Object)calculationDate);
    }
}

