/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.update.balance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FinanceUpdateBalancesRelevantTransactionsTargetsProvider
extends BaseTargetsProvider<EntityReference<Transaction>> {
    public Collection<EntityReference<Transaction>> getTargets(MessageContext context) throws Exception {
        Date operationDate = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.OPERATION_DATE);
        Date calculationDate = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CALCULATION_DATE);
        EntityContainer chartOfAccountsElementContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CHART_OF_ACCOUNTS_ELEMENT_CONTAINER);
        ArrayList<EntityReference<Transaction>> transactionReferences = new ArrayList<EntityReference<Transaction>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.accountUid.name(), (Object)chartOfAccountsElementContainer.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)TransactionSplitIndex.Property.operationDate.name(), null), SearchCriterion.le((String)TransactionSplitIndex.Property.operationDate.name(), (Object)operationDate)}));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)TransactionSplitIndex.Property.calculationDate.name(), null), SearchCriterion.le((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)calculationDate)}));
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            EntityReference transactionReference = transactionSplitIndex.getSource();
            if (transactionReferences.contains(transactionReference)) continue;
            transactionReferences.add((EntityReference<Transaction>)transactionReference);
        }
        return transactionReferences;
    }
}

