/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.update.balance;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.FinanceBalancesUpdateTaskConfiguration;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceIbusHelper;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FinanceUpdateBalancesUpdateBalancesProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        FinanceBalancesUpdateTaskConfiguration configuration = (FinanceBalancesUpdateTaskConfiguration)context.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION);
        EntityReference organization = (EntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.ORGANIZATION_REFERENCE);
        EntityContainer chartOfAccountsSettingsContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CHART_OF_ACCOUNTS_SETTINGS_CONTAINER);
        Date operationDate = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.OPERATION_DATE);
        Date calculationDate = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CALCULATION_DATE);
        EntityContainer chartOfAccountsElementContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CHART_OF_ACCOUNTS_ELEMENT_CONTAINER);
        ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity();
        ChartOfAccountsElement chartOfAccountsElement = (ChartOfAccountsElement)chartOfAccountsElementContainer.getEntity();
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)chartOfAccountsElement.getType());
        List<FinanceIbusHelper.DimensionInfo> dimensionInfos = this.getDimensionInfos(chartOfAccountsElementSettings, context);
        List dimensionInfosCombinations = CollectionUtil.combinations(new HashSet<FinanceIbusHelper.DimensionInfo>(dimensionInfos));
        List<Map<FinanceIbusHelper.DimensionInfo, Object>> dimensionsValuesCombinations = FinanceIbusHelper.collectTransactionsDimensionsValuesCombinations((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementContainer.toReference(), operationDate, calculationDate, dimensionInfos);
        dimensionsValuesCombinations.add(Collections.emptyMap());
        int dimensionInfosCombinationCount = 0;
        for (Set dimensionInfosCombination : dimensionInfosCombinations) {
            ++dimensionInfosCombinationCount;
            HashSet<String> processedDimensionsValuesCombinations = new HashSet<String>();
            int dimensionsValuesCombinationCount = 0;
            block1: for (Map<FinanceIbusHelper.DimensionInfo, Object> dimensionsValuesCombination : dimensionsValuesCombinations) {
                this.log.debug("processing -> " + chartOfAccountsElement + " -> " + dimensionInfosCombinationCount + "/" + dimensionInfosCombinations.size() + " - " + ++dimensionsValuesCombinationCount + "/" + dimensionsValuesCombinations.size());
                Object dimension1Object = null;
                Object dimension2Object = null;
                Object dimension3Object = null;
                HashMap<FinanceHelper.Dimension, String> dimensions = new HashMap<FinanceHelper.Dimension, String>();
                for (FinanceIbusHelper.DimensionInfo dimensionInfo : dimensionInfosCombination) {
                    Object dimensionObject = dimensionsValuesCombination.get(dimensionInfo);
                    if (dimensionObject == null) continue block1;
                    String dimensionValue = FinanceIbusHelper.getTransactionDimensionValue(dimensionInfo.getDimension(), dimensionObject);
                    if (dimensionInfo.getDimension() == FinanceHelper.Dimension.DIMENSION_1) {
                        dimension1Object = dimensionObject;
                        dimensions.put(FinanceHelper.Dimension.DIMENSION_1, dimensionValue);
                        continue;
                    }
                    if (dimensionInfo.getDimension() == FinanceHelper.Dimension.DIMENSION_2) {
                        dimension2Object = dimensionObject;
                        dimensions.put(FinanceHelper.Dimension.DIMENSION_2, dimensionValue);
                        continue;
                    }
                    if (dimensionInfo.getDimension() != FinanceHelper.Dimension.DIMENSION_3) continue;
                    dimension3Object = dimensionObject;
                    dimensions.put(FinanceHelper.Dimension.DIMENSION_3, dimensionValue);
                }
                String key = String.format("%s_%s_%s", dimension1Object, dimension2Object, dimension3Object);
                if (processedDimensionsValuesCombinations.contains(key)) continue;
                processedDimensionsValuesCombinations.add(key);
                BigDecimal debit = FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElementContainer.toReference(), (Date)operationDate, (Date)calculationDate, dimensions, (boolean)false);
                BigDecimal credit = FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElementContainer.toReference(), (Date)operationDate, (Date)calculationDate, dimensions, (boolean)true);
                OpeningBalance balance = new OpeningBalance();
                balance.setAuxiliary(configuration.isAuxiliary());
                balance.setOrganizationUid(organization.getUid());
                balance.setAccountUid(chartOfAccountsElementContainer.getUid());
                balance.setDimension1((String)dimensions.get(FinanceHelper.Dimension.DIMENSION_1));
                balance.setDimension2((String)dimensions.get(FinanceHelper.Dimension.DIMENSION_2));
                balance.setDimension3((String)dimensions.get(FinanceHelper.Dimension.DIMENSION_3));
                balance.setOperationDate(operationDate);
                balance.setCalculationDate(calculationDate);
                balance.setDebit(ModelHelper.bigDecimal2Long((BigDecimal)debit));
                balance.setCredit(ModelHelper.bigDecimal2Long((BigDecimal)credit));
                AssetsStorage.get().save((BaseAsset)balance);
            }
        }
    }

    protected List<FinanceIbusHelper.DimensionInfo> getDimensionInfos(BasicChartOfAccountsElementSettings chartOfAccountsElementSettings, MessageContext context) {
        return FinanceIbusHelper.getDimensionInfos(chartOfAccountsElementSettings);
    }
}

