/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.update.balance;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.OpeningBalance;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.FinanceBalancesUpdateTaskConfiguration;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ShiftNonAuxiliaryOldRecordsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        FinanceBalancesUpdateTaskConfiguration config = (FinanceBalancesUpdateTaskConfiguration)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION);
        if (!config.isDeleteNonAuxiliaryOldRecords()) {
            this.log.debug("deleteNonAuxiliaryOldRecords is false, skipping");
            return;
        }
        LongRunningTaskCallback callback = (LongRunningTaskCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK);
        Date operationDate = (Date)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.OPERATION_DATE);
        Date calculationDate = (Date)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.CALCULATION_DATE);
        SearchQuery oldQuery = new SearchQuery();
        oldQuery.getCriteria().getCriterions().add(SearchCriterion.lt((String)OpeningBalance.Property.operationDate.name(), (Object)operationDate));
        oldQuery.getCriteria().getCriterions().add(SearchCriterion.lt((String)OpeningBalance.Property.calculationDate.name(), (Object)calculationDate));
        oldQuery.getCriteria().getCriterions().add(SearchCriterion.ne((String)OpeningBalance.Property.auxiliary.name(), (Object)true));
        Map<List, List<OpeningBalance>> oldBalances = AssetsStorage.get().search(OpeningBalance.class, oldQuery).getData().stream().collect(Collectors.groupingBy(ShiftNonAuxiliaryOldRecordsProcessor::getOpeningBalanceKey));
        for (Map.Entry<List, List<OpeningBalance>> entry : oldBalances.entrySet()) {
            String key = String.join((CharSequence)"/", entry.getKey());
            if (entry.getValue().size() > 1) {
                this.log.warn("found {} old records for {}, will not shift", (Object)entry.getValue().size(), (Object)key);
                callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0414\u043b\u044f \u043a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u0438 {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439 \u0441\u0442\u0430\u0440\u043e\u0439 \u043e\u0442\u0441\u0435\u0447\u043a\u0438, \u0441\u0434\u0432\u0438\u0433\u0430 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442", (Object[])new Object[]{key}));
                continue;
            }
            OpeningBalance oldRecord = entry.getValue().get(0);
            this.log.debug("shifting old record {} (uid={}) from {}/{} to {}/{}", new Object[]{key, oldRecord.getUid(), oldRecord.getOperationDate(), oldRecord.getCalculationDate(), operationDate, calculationDate});
            oldRecord.setOperationDate(operationDate);
            oldRecord.setCalculationDate(calculationDate);
            AssetsStorage.get().save((BaseAsset)oldRecord);
        }
    }

    private static List<String> getOpeningBalanceKey(OpeningBalance balance) {
        return Arrays.asList(balance.getOrganizationUid(), balance.getAccountUid(), balance.getDimension1(), balance.getDimension2(), balance.getDimension3());
    }
}

