/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.http;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpInvocationContext {
    private static final ThreadLocal<HttpInvocationContext> INSTANCE = ThreadLocal.withInitial(HttpInvocationContext::new);
    private final List<Transaction> transactions = new ArrayList<Transaction>();
    private static final Logger log = LoggerFactory.getLogger(HttpInvocationContext.class);
    private boolean active;

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public static HttpInvocationContext get() {
        return INSTANCE.get();
    }

    public boolean isActive() {
        return this.active;
    }

    public void begin() {
        this.transactions.clear();
        this.active = true;
    }

    public void addTransaction(Transaction transaction) {
        if (this.active) {
            this.transactions.add(transaction);
        } else {
            log.warn("addTransaction() ignored because of non-active state, maybe you forgot to wrap your subroute with com.gridnine.xtrip.server.ibus.http.HttpLoggingAdvice?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document buildJsonDocument() throws Exception {
        byte[] content;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            JsonFactory jfactory = new JsonFactory();
            try (JsonGenerator jGenerator = jfactory.createGenerator((OutputStream)baos, JsonEncoding.UTF8);){
                jGenerator.writeStartObject();
                jGenerator.writeFieldName("http-transactions");
                jGenerator.writeStartArray();
                for (Transaction transaction : this.transactions) {
                    transaction.toJson(jGenerator, baos);
                }
                jGenerator.writeEndArray();
                jGenerator.writeEndObject();
            }
            content = baos.toByteArray();
        }
        Document document = new Document();
        document.setContent(content);
        document.setCheckSum(DigestUtils.md5Hex((byte[])document.getContent()));
        document.setContentType(ContentType.XML);
        document.setCreated(new Date());
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document buildDocument(boolean xmlBody) throws Exception {
        byte[] content;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (XMLStreamWriter writer = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)XSUtil.getXMLOutputFactory().createXMLStreamWriter(baos));){
                writer.writeStartDocument();
                writer.writeStartElement("http-transactions");
                for (Transaction transaction : this.transactions) {
                    transaction.toXML(writer, xmlBody, baos);
                }
                writer.writeEndElement();
                writer.writeEndDocument();
            }
            content = baos.toByteArray();
        }
        Document document = new Document();
        document.setContent(content);
        document.setCheckSum(DigestUtils.md5Hex((byte[])document.getContent()));
        document.setContentType(ContentType.XML);
        document.setCreated(new Date());
        return document;
    }

    public void end() {
        this.transactions.clear();
        this.active = false;
    }

    public static class Transaction {
        private Date startingTime;
        private Date finishingTime;
        private HttpRequest request;
        private HttpResponse response;
        private ExceptionData exception;

        public Date getStartingTime() {
            return this.startingTime;
        }

        public void setStartingTime(Date startingTime) {
            this.startingTime = startingTime;
        }

        public Date getFinishingTime() {
            return this.finishingTime;
        }

        public void setFinishingTime(Date finishingTime) {
            this.finishingTime = finishingTime;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest request) {
            this.request = request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse response) {
            this.response = response;
        }

        public ExceptionData getException() {
            return this.exception;
        }

        public void setException(ExceptionData exception) {
            this.exception = exception;
        }

        public void toXML(XMLStreamWriter writer, boolean xmlBody, OutputStream os) throws Exception {
            String url;
            int urlParamsStartIndex;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            writer.writeStartElement("transaction");
            writer.writeAttribute("startingTime", sdf.format(this.startingTime));
            if (this.finishingTime != null) {
                writer.writeAttribute("finishingTime", sdf.format(this.finishingTime));
            }
            if (this.startingTime != null && this.finishingTime != null) {
                writer.writeAttribute("timing", String.format("%d ms", this.finishingTime.getTime() - this.startingTime.getTime()));
            }
            writer.writeStartElement("request");
            if (this.request.getRequestMethod() != null) {
                writer.writeAttribute("method", this.request.getRequestMethod().name());
            }
            String urlWithoutParams = (urlParamsStartIndex = (url = this.request.getUrl()).indexOf("?")) == -1 ? url : url.substring(0, urlParamsStartIndex);
            writer.writeAttribute("url", urlWithoutParams);
            if (urlParamsStartIndex != -1) {
                Iterator urlParamsStr = url.substring(urlParamsStartIndex + 1);
                String[] urlParams = ((String)((Object)urlParamsStr)).split("&");
                writer.writeStartElement("url-params");
                for (String urlParam : urlParams) {
                    writer.writeStartElement("param");
                    String[] pair = urlParam.split("=");
                    if (pair.length > 0) {
                        String name = pair[0];
                        if (TextUtil.nonBlank((String)name)) {
                            writer.writeAttribute("name", name);
                        }
                        if (pair.length > 1) {
                            String value = pair[1];
                            writer.writeAttribute("value", value);
                        }
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeStartElement("request-properties");
            for (Map.Entry entry : this.request.getRequestProperties().entrySet()) {
                writer.writeStartElement("prop");
                if (TextUtil.nonBlank((String)((String)entry.getKey()))) {
                    writer.writeAttribute("name", (String)entry.getKey());
                }
                writer.writeAttribute("value", (String)entry.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeStartElement("query-properties");
            for (Map.Entry entry : this.request.getQueryParameters().entrySet()) {
                writer.writeStartElement("prop");
                if (TextUtil.nonBlank((String)((String)entry.getKey()))) {
                    writer.writeAttribute("name", (String)entry.getKey());
                }
                writer.writeAttribute("value", Arrays.toString((Object[])entry.getValue()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
            if (xmlBody) {
                writer.writeStartElement("body");
                writer.writeCharacters("");
                writer.flush();
                MiscUtil.writeBytesWithoutXmlHeader((OutputStream)os, (byte[])this.request.getBody());
                os.flush();
                writer.writeEndElement();
            } else {
                this.writeBytesAsCData(writer, "body", this.request.getBody());
            }
            writer.writeEndElement();
            writer.writeStartElement("response");
            XSHelper.writeInt((XMLStreamWriter)writer, (String)"code", (int)this.response.getResponseCode());
            XSHelper.writeString((XMLStreamWriter)writer, (String)"message", (String)this.response.getResponseMessage());
            XSHelper.writeString((XMLStreamWriter)writer, (String)"contentType", (String)this.response.getContentType());
            writer.writeStartElement("cookies");
            for (Map.Entry entry : this.response.getCookies().entrySet()) {
                writer.writeStartElement("cookie");
                if (TextUtil.nonBlank((String)((String)entry.getKey()))) {
                    writer.writeAttribute("name", (String)entry.getKey());
                }
                writer.writeAttribute("value", TextUtil.join((String)";", (Iterable)((Iterable)entry.getValue())));
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeStartElement("headers");
            for (Map.Entry entry : this.response.getHeaders().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    writer.writeStartElement("header");
                    if (TextUtil.nonBlank((String)((String)entry.getKey()))) {
                        writer.writeAttribute("name", (String)entry.getKey());
                    }
                    writer.writeAttribute("value", value);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            if (this.response.getContentType() != null && this.response.getContentType().contains("application/pdf")) {
                this.writeBytes(writer, "body", this.response.getBody());
            } else if (xmlBody) {
                writer.writeStartElement("body");
                writer.writeCharacters("");
                writer.flush();
                MiscUtil.writeBytesWithoutXmlHeader((OutputStream)os, (byte[])this.response.getBody());
                os.flush();
                writer.writeEndElement();
            } else {
                this.writeBytesAsCData(writer, "body", this.response.getBody());
            }
            this.writeBytesAsCData(writer, "content", this.response.getContent());
            this.writeBytesAsCData(writer, "error", this.response.getError());
            writer.writeEndElement();
            if (this.exception != null) {
                writer.writeStartElement("exception");
                writer.writeAttribute("finishingTime", sdf.format(this.exception.getFinishingDate()));
                writer.writeAttribute("timing", Long.toString(this.exception.getTiming()));
                writer.writeCData(TextUtil.getExceptionStackTraceRegular((Throwable)this.exception.getException()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        private void writeBytesAsCData(XMLStreamWriter writer, String title, byte[] bytes) throws Exception {
            if (bytes == null) {
                return;
            }
            XSHelper.writeString((XMLStreamWriter)writer, (String)title, (String)new String(bytes, StandardCharsets.UTF_8), (boolean)true);
        }

        private void writeBytes(XMLStreamWriter writer, String title, byte[] bytes) throws Exception {
            if (bytes == null) {
                return;
            }
            XSHelper.writeBytes((XMLStreamWriter)writer, (String)title, (byte[])bytes);
        }

        public void toJson(JsonGenerator jGenerator, OutputStream os) throws Exception {
            String url;
            int urlParamsStartIndex;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            jGenerator.writeStartObject();
            jGenerator.writeStringField("startingTime", sdf.format(this.startingTime));
            if (this.finishingTime != null) {
                jGenerator.writeStringField("finishingTime", sdf.format(this.finishingTime));
            }
            if (this.startingTime != null && this.finishingTime != null) {
                jGenerator.writeNumberField("timingMs", this.finishingTime.getTime() - this.startingTime.getTime());
            }
            jGenerator.writeFieldName("request");
            jGenerator.writeStartObject();
            if (this.request.getRequestMethod() != null) {
                jGenerator.writeStringField("method", this.request.getRequestMethod().name());
            }
            String urlWithoutParams = (urlParamsStartIndex = (url = this.request.getUrl()).indexOf("?")) == -1 ? url : url.substring(0, urlParamsStartIndex);
            jGenerator.writeStringField("url", urlWithoutParams);
            if (urlParamsStartIndex != -1) {
                Iterator urlParamsStr = url.substring(urlParamsStartIndex + 1);
                String[] urlParams = ((String)((Object)urlParamsStr)).split("&");
                jGenerator.writeFieldName("url-params");
                jGenerator.writeStartArray();
                for (String urlParam : urlParams) {
                    jGenerator.writeStartObject();
                    String[] pair = urlParam.split("=");
                    if (pair.length > 0) {
                        String name = pair[0];
                        if (TextUtil.nonBlank((String)name)) {
                            jGenerator.writeStringField("name", name);
                        }
                        if (pair.length > 1) {
                            String value = pair[1];
                            jGenerator.writeStringField("value", value);
                        }
                    }
                    jGenerator.writeEndObject();
                }
                jGenerator.writeEndArray();
            }
            jGenerator.writeFieldName("request-properties");
            jGenerator.writeStartArray();
            for (Map.Entry entry : this.request.getRequestProperties().entrySet()) {
                jGenerator.writeStartObject();
                if (TextUtil.nonBlank((String)((String)entry.getKey()))) {
                    jGenerator.writeStringField("name", (String)entry.getKey());
                }
                jGenerator.writeStringField("value", (String)entry.getValue());
                jGenerator.writeEndObject();
            }
            jGenerator.writeEndArray();
            jGenerator.writeFieldName("query-properties");
            jGenerator.writeStartArray();
            for (Map.Entry entry : this.request.getQueryParameters().entrySet()) {
                jGenerator.writeStartObject();
                if (TextUtil.nonBlank((String)((String)entry.getKey()))) {
                    jGenerator.writeStringField("name", (String)entry.getKey());
                }
                jGenerator.writeStringField("value", Arrays.toString((Object[])entry.getValue()));
                jGenerator.writeEndObject();
            }
            jGenerator.writeEndArray();
            jGenerator.writeFieldName("body");
            jGenerator.flush();
            os.write(":".getBytes(StandardCharsets.UTF_8));
            os.write(this.request.getBody());
            os.flush();
            ((JsonWriteContext)jGenerator.getOutputContext()).writeValue();
            jGenerator.writeEndObject();
            jGenerator.writeFieldName("response");
            jGenerator.writeStartObject();
            jGenerator.writeNumberField("code", this.response.getResponseCode());
            jGenerator.writeStringField("message", this.response.getResponseMessage());
            jGenerator.writeStringField("contentType", this.response.getContentType());
            jGenerator.writeFieldName("cookies");
            jGenerator.writeStartArray();
            for (Map.Entry entry : this.response.getCookies().entrySet()) {
                jGenerator.writeStartObject();
                if (TextUtil.nonBlank((String)((String)entry.getKey()))) {
                    jGenerator.writeStringField("name", (String)entry.getKey());
                }
                jGenerator.writeStringField("value", TextUtil.join((String)";", (Iterable)((Iterable)entry.getValue())));
                jGenerator.writeEndObject();
            }
            jGenerator.writeEndArray();
            jGenerator.writeFieldName("headers");
            jGenerator.writeStartArray();
            for (Map.Entry entry : this.response.getHeaders().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    jGenerator.writeStartObject();
                    if (TextUtil.nonBlank((String)((String)entry.getKey()))) {
                        jGenerator.writeStringField("name", (String)entry.getKey());
                    }
                    jGenerator.writeStringField("value", value);
                    jGenerator.writeEndObject();
                }
            }
            jGenerator.writeEndArray();
            if (this.response.getContentType() != null && this.response.getContentType().contains("application/pdf")) {
                jGenerator.writeBinaryField("body", this.response.getBody());
            } else {
                jGenerator.writeFieldName("body");
                jGenerator.flush();
                os.write(":".getBytes(StandardCharsets.UTF_8));
                os.write(this.response.getBody());
                os.flush();
                ((JsonWriteContext)jGenerator.getOutputContext()).writeValue();
            }
            if (this.response.getContent() != null) {
                jGenerator.writeBinaryField("content", this.response.getContent());
            }
            if (this.response.getError() != null) {
                jGenerator.writeBinaryField("error", this.response.getError());
            }
            jGenerator.writeEndObject();
            if (this.exception != null) {
                jGenerator.writeFieldName("exception");
                jGenerator.writeStartObject();
                jGenerator.writeStringField("finishingTime", sdf.format(this.exception.getFinishingDate()));
                jGenerator.writeStringField("timing", Long.toString(this.exception.getTiming()));
                jGenerator.writeStringField("stacktrace", TextUtil.getExceptionStackTraceRegular((Throwable)this.exception.getException()));
                jGenerator.writeEndObject();
            }
            jGenerator.writeEndObject();
        }

        public static final class ExceptionData {
            public final Throwable exception;
            private final Date finishingDate;
            private final long timing;

            public ExceptionData(Throwable exception, long startingTime) {
                this.exception = exception;
                this.finishingDate = new Date();
                this.timing = this.finishingDate.getTime() - startingTime;
            }

            public Throwable getException() {
                return this.exception;
            }

            public Date getFinishingDate() {
                return this.finishingDate;
            }

            public long getTiming() {
                return this.timing;
            }
        }
    }
}

