/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.http;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpCredentials;
import com.gridnine.xtrip.common.model.system.HttpNTLMCredentials;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpInvoker
extends BaseProcessor {
    private static final long CONNECTION_TIME_TO_LIVE_TIMEOUT = 5L;
    private static final TimeUnit CONNECTION_TIME_TO_LIVE_TIME_UNIT = TimeUnit.MINUTES;
    private static final String USER_AGENT = String.format("MidOffice/3.0 (%s; %s; x%s)", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("sun.arch.data.model"));
    private static final Lock UPDATE_CLIENTS_LOCK = new ReentrantLock();
    private static final List<String> EXCEPTION_KEY_TO_REPEAT = Arrays.asList("java.net.SocketTimeoutException:connect timed out", "java.net.SocketException:Network is unreachable", "java.net.NoRouteToHostException:No route to host");
    private static final int ATTEMPTS_COUNT = 3;
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final TrustManager[] TRUST_MANAGERS = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};

    /*
     * Exception decompiling
     */
    public void process(MessageContext ctx) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Throwable unwrap(Throwable e) {
        if (e instanceof SSLException) {
            if (e.getCause() != null) {
                return HttpInvoker.unwrap(e.getCause());
            }
            if (e.getSuppressed() != null && e.getSuppressed().length == 1) {
                return HttpInvoker.unwrap(e.getSuppressed()[0]);
            }
        }
        return e;
    }

    private HttpClientContext getContext(HttpRequest request) {
        HttpClientContext context = new HttpClientContext();
        context.setUserToken(this.getToken(request.getCredentials()));
        HttpCredentials credentials = request.getCredentials();
        if (credentials != null) {
            BasicCredentialsProvider cp = new BasicCredentialsProvider();
            if (!(credentials instanceof HttpNTLMCredentials)) {
                throw new IllegalArgumentException("unsupported credentials");
            }
            HttpNTLMCredentials ntlm = (HttpNTLMCredentials)credentials;
            cp.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(ntlm.getUserName(), ntlm.getPassword(), ntlm.getWorkstation(), ntlm.getDomain()));
            context.setCredentialsProvider((CredentialsProvider)cp);
        }
        context.setCookieStore((CookieStore)new BasicCookieStore());
        return context;
    }

    private Object getToken(HttpCredentials credentials) {
        if (null == credentials) {
            return null;
        }
        if (credentials instanceof HttpNTLMCredentials) {
            return ((HttpNTLMCredentials)credentials).getUserName();
        }
        throw new IllegalArgumentException("unsupported credentials");
    }

    private static HttpUriRequest getMessage(String url, HttpRequest request) {
        String method = request.getRequestMethod() != null ? request.getRequestMethod().name() : "GET";
        RequestBuilder requestBuilder = RequestBuilder.create((String)method);
        requestBuilder.setUri(url);
        for (Map.Entry entry : request.getQueryParameters().entrySet()) {
            String key = (String)entry.getKey();
            Arrays.stream((Object[])entry.getValue()).forEach(v -> requestBuilder.addParameter(key, v));
        }
        request.getRequestProperties().forEach((arg_0, arg_1) -> ((RequestBuilder)requestBuilder).addHeader(arg_0, arg_1));
        if (!request.getRequestProperties().containsKey((Object)"Content-Type")) {
            requestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        if (!request.getRequestProperties().containsKey((Object)"Accept")) {
            requestBuilder.addHeader("Accept", "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        }
        if (Boolean.FALSE.equals(request.getUseCaches())) {
            if (!request.getRequestProperties().containsKey((Object)"Cache-Control")) {
                requestBuilder.addHeader("Cache-Control", "no-cache");
            }
            if (!request.getRequestProperties().containsKey((Object)"Pragma")) {
                requestBuilder.addHeader("Pragma", "no-cache");
            }
        }
        if (request.getBody() != null) {
            requestBuilder.setEntity((HttpEntity)new ByteArrayEntity(request.getBody()));
        }
        RequestConfig.Builder rcb = RequestConfig.custom();
        if (request.getConnectTimeout() != null) {
            rcb.setConnectTimeout(request.getConnectTimeout().intValue());
        } else {
            Integer defaultConnectionTimeout = Integer.getInteger("sun.net.client.defaultConnectTimeout");
            if (defaultConnectionTimeout != null) {
                rcb.setConnectTimeout(defaultConnectionTimeout.intValue());
            }
        }
        if (request.getReadTimeout() != null) {
            rcb.setSocketTimeout(request.getReadTimeout().intValue());
        } else {
            Integer defaultReadTimeout = Integer.getInteger("sun.net.client.defaultReadTimeout");
            if (defaultReadTimeout != null) {
                rcb.setSocketTimeout(defaultReadTimeout.intValue());
            }
        }
        requestBuilder.setConfig(rcb.build());
        return requestBuilder.build();
    }

    private static CloseableHttpClient buildClient(HttpRequest request) throws GeneralSecurityException {
        HttpClientBuilder builder = HttpClients.custom();
        builder.setUserAgent(USER_AGENT);
        if (request.isUseSsl()) {
            if (request.getCustomSsocketFactory() != null) {
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory((SSLSocketFactory)request.getCustomSsocketFactory(), (HostnameVerifier)new DefaultHostnameVerifier()));
            } else if (request.isUseTrustfulManager()) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, TRUST_MANAGERS, new SecureRandom());
                builder.setSSLContext(sslContext);
            }
        }
        if (request.isUseTrustfulHostnameVerifier()) {
            builder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        builder.setMaxConnTotal(500);
        builder.setMaxConnPerRoute(250);
        builder.setConnectionTimeToLive(5L, CONNECTION_TIME_TO_LIVE_TIME_UNIT);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CloseableHttpClient getClient(String url, HttpRequest request) throws GeneralSecurityException {
        HttpClientFacade client = Holder.CLIENTS.get(url);
        if (client != null) {
            return client;
        }
        Lock lock = UPDATE_CLIENTS_LOCK;
        lock.lock();
        try {
            client = Holder.CLIENTS.get(url);
            if (client != null) {
                HttpClientFacade httpClientFacade = client;
                return httpClientFacade;
            }
            client = new HttpClientFacade(HttpInvoker.buildClient(request));
            Holder.CLIENTS.put(url, client);
            HttpClientFacade httpClientFacade = client;
            return httpClientFacade;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean haveToThrow(Throwable e, Map<String, Integer> exceptionCounters) {
        String key = this.getExceptionKey(e);
        if (!EXCEPTION_KEY_TO_REPEAT.contains(key)) {
            return true;
        }
        Integer count = MiscUtil.guarded((Integer)exceptionCounters.get(key));
        if (count + 1 < 3) {
            exceptionCounters.put(key, count + 1);
            return false;
        }
        return true;
    }

    private String getExceptionKey(Throwable e) {
        return e.getClass().getName().concat(":").concat(MiscUtil.guarded((String)e.getMessage()));
    }

    private Xeption getThrownException(Throwable e) {
        if (e instanceof SocketTimeoutException && "connect timed out".equals(e.getMessage())) {
            return Xeption.forAdmin((String)"\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Throwable)e, (Object[])new Object[0]);
        }
        if (e instanceof NoRouteToHostException && "No route to host".equals(e.getMessage())) {
            return Xeption.forAdmin((String)"\u041d\u0435\u0442 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430 \u043a \u0445\u043e\u0441\u0442\u0443 (No route to host)", (Throwable)e, (Object[])new Object[0]);
        }
        if (e instanceof ConnectException && "Connection refused".equals(e.getMessage())) {
            return Xeption.forEndUser((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f (Connection refused). \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u0437\u0436\u0435.", (Throwable)e, (Object[])new Object[0]);
        }
        if (e instanceof SocketException && "Network is unreachable".equals(e.getMessage())) {
            return Xeption.forAdmin((String)"\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0441\u0435\u0442\u044c (Network is unreachable)", (Throwable)e, (Object[])new Object[0]);
        }
        return null;
    }

    public static String buildUrl(HttpRequest request) {
        StringBuilder sb = new StringBuilder();
        if (request.getUrl().startsWith(HTTPS_PREFIX)) {
            request.setUseSsl(true);
        } else if (!request.getUrl().startsWith(HTTP_PREFIX)) {
            sb.append(request.isUseSsl() ? HTTPS_PREFIX : HTTP_PREFIX);
        }
        sb.append(request.getUrl());
        return sb.toString();
    }

    private static /* synthetic */ List lambda$process$2(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ void lambda$process$1(HttpResponse response, Cookie cookie) {
        String name = cookie.getName();
        List values = response.getCookies().computeIfAbsent(name, k -> new ArrayList());
        values.add(cookie.getValue());
    }

    private static class Holder {
        public static final Map<String, HttpClientFacade> CLIENTS = new ConcurrentHashMap<String, HttpClientFacade>();

        private Holder() {
        }

        static {
            final Logger log = LoggerFactory.getLogger(HttpInvoker.class);
            long timeout = 5L;
            final TimeUnit timeUnit = CONNECTION_TIME_TO_LIVE_TIME_UNIT;
            final Thread expared = new Thread("close-expared-http-connections"){

                @Override
                public void run() {
                    try {
                        block6: while (true) {
                            try {
                                Thread.sleep(timeUnit.toMillis(5L));
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                            Iterator<HttpClientFacade> e = CLIENTS.values().iterator();
                            while (true) {
                                if (!e.hasNext()) continue block6;
                                HttpClientFacade facade = e.next();
                                if (Thread.currentThread().isInterrupted()) {
                                    return;
                                }
                                try {
                                    ClientConnectionManager cm = facade.getClient().getConnectionManager();
                                    cm.closeExpiredConnections();
                                    cm.closeIdleConnections(5L, timeUnit);
                                }
                                catch (Exception e2) {
                                    log.error("failed to close expired connection", (Throwable)e2);
                                }
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        log.error("an unexpected error has occurred", t);
                        return;
                    }
                }
            };
            expared.setDaemon(true);
            expared.start();
            Environment.publish((Object)new Closeable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    try {
                        expared.interrupt();
                        try {
                            expared.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Lock lock = UPDATE_CLIENTS_LOCK;
                        lock.lock();
                        try {
                            for (HttpClientFacade facade : CLIENTS.values()) {
                                try {
                                    facade.getClient().close();
                                }
                                catch (Exception e) {
                                    log.error("failed to close http client", (Throwable)e);
                                }
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    catch (Throwable t) {
                        log.error("an unexpected error has occurred", t);
                    }
                }
            });
        }
    }

    private static class HttpClientFacade
    extends CloseableHttpClient {
        private final CloseableHttpClient client;

        public HttpClientFacade(CloseableHttpClient client) {
            this.client = client;
        }

        public CloseableHttpClient getClient() {
            return this.client;
        }

        protected CloseableHttpResponse doExecute(HttpHost httpHost, org.apache.http.HttpRequest httpRequest, HttpContext httpContext) throws IOException {
            return this.client.execute(httpHost, httpRequest, httpContext);
        }

        public void close() throws IOException {
        }

        public HttpParams getParams() {
            return this.client.getParams();
        }

        public ClientConnectionManager getConnectionManager() {
            return this.client.getConnectionManager();
        }
    }
}

