/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.http;

import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.digest.DigestUtils;

public class HttpLogDocumentBuilder
extends BaseProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        HttpRequest request = (HttpRequest)ctx.getMandatoryObject(IBusHttpContextKeys.HTTP_REQUEST.name());
        HttpResponse response = (HttpResponse)ctx.getMandatoryObject(IBusHttpContextKeys.HTTP_RESPONSE.name());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             XMLStreamWriter writer = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)XSUtil.getXMLOutputFactory().createXMLStreamWriter(baos));){
            writer.writeStartDocument();
            writer.writeStartElement("http-invoke");
            this.writeRequest(request, writer);
            this.writeResponse(response, writer);
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        Document document = new Document();
        document.setContent(baos.toByteArray());
        document.setCheckSum(DigestUtils.md5Hex((byte[])document.getContent()));
        document.setContentType(ContentType.XML);
        document.setCreated(new Date());
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_LOG_DOCUMENT, (Object)document);
    }

    private void writeRequest(HttpRequest request, XMLStreamWriter writer) throws XMLStreamException {
        Set entrySet;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        writer.writeStartElement("request");
        writer.writeAttribute("start", sdf.format(new Date()));
        writer.writeStartElement("method");
        writer.writeCharacters(request.getRequestMethod().name());
        writer.writeEndElement();
        writer.writeStartElement("url");
        writer.writeCharacters(request.getUrl());
        writer.writeEndElement();
        writer.writeStartElement("headers");
        if (request.getRequestProperties().size() > 0) {
            entrySet = request.getRequestProperties().entrySet();
            for (Map.Entry entry : entrySet) {
                writer.writeStartElement((String)entry.getKey());
                writer.writeCharacters((String)entry.getValue());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
        if (request.getBody() != null) {
            writer.writeStartElement("body");
            writer.writeCData(new String(request.getBody()));
            writer.writeEndElement();
        }
        writer.writeStartElement("parameters");
        entrySet = request.getQueryParameters().entrySet();
        for (Map.Entry entry : entrySet) {
            writer.writeStartElement((String)entry.getKey());
            if (((String[])entry.getValue()).length == 1) {
                writer.writeCharacters(((String[])entry.getValue())[0]);
            } else {
                writer.writeCharacters(Arrays.toString((Object[])entry.getValue()));
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeResponse(HttpResponse response, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("response");
        writer.writeStartElement("code");
        writer.writeCharacters(String.valueOf(response.getResponseCode()));
        writer.writeEndElement();
        writer.writeStartElement("contentType");
        writer.writeCharacters(response.getContentType());
        writer.writeEndElement();
        writer.writeStartElement("characterEncoding");
        if (response.getCharacterEncoding() != null) {
            writer.writeCharacters(response.getCharacterEncoding());
        }
        writer.writeEndElement();
        writer.writeStartElement("responseMessage");
        writer.writeCharacters(response.getResponseMessage());
        writer.writeEndElement();
        if (response.getBody() != null) {
            writer.writeStartElement("body");
            writer.writeCData(new String(response.getBody()));
            writer.writeEndElement();
        }
        if (response.getContent() != null) {
            writer.writeStartElement("content");
            writer.writeCData(new String(response.getContent()));
            writer.writeEndElement();
        }
        if (response.getError() != null) {
            writer.writeStartElement("error");
            writer.writeCData(new String(response.getError()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

