/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.impl.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.IntegrationBusException;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.EmailPollerPolicy;
import com.gridnine.xtrip.common.model.system.EmailPollerSettings;
import com.gridnine.xtrip.common.model.system.EmailServerProtocol;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusStartPoint;
import com.gridnine.xtrip.server.ibus.model.EmailInEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.EndpointType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.BCodec;
import org.apache.commons.codec.net.QCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbusEmailInEndpoint
implements IbusStartPoint {
    protected static final Logger log = LoggerFactory.getLogger(IbusEmailInEndpoint.class);
    private static final int connectionTimeout = 30000;
    private final EmailInEndpointDescription descr;
    private final IbusStartPoint.IbusStartPointFactoryCallback clb;
    private static final Pattern PATTERN = Pattern.compile("\\A=\\?(.+)\\?([Bb]|[Qq])\\?(.*)\\?=\\z");

    public IbusEmailInEndpoint(String pointId, IbusStartPoint.IbusStartPointFactoryCallback routeCallback) {
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        this.descr = (EmailInEndpointDescription)reg.getEndpoint(pointId, EmailInEndpointDescription.class);
        this.clb = routeCallback;
    }

    public void sendMessage(IbusMessage msg) throws Exception {
        this.clb.startRoute(msg);
    }

    public boolean canSendMessage() {
        return true;
    }

    public boolean isPoller() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void startPolling() {
        block38: {
            uid = this.descr.getSettingsUid();
            settingsRef = new EntityReference(uid, EmailPollerSettings.class, null);
            ctr = EntityStorage.get().resolve(settingsRef);
            if (ctr == null) {
                IbusEmailInEndpoint.log.warn(String.format("email settings with uid %s is absent in DB", new Object[]{uid}));
                return;
            }
            ett = (EmailPollerSettings)ctr.getEntity();
            if (TextUtil.isBlank((String)ett.getEmail())) {
                IbusEmailInEndpoint.log.warn(String.format("no email is defined id email settings %s", new Object[]{ett}));
                return;
            }
            if (TextUtil.isBlank((String)ett.getPassword())) {
                IbusEmailInEndpoint.log.warn(String.format("no password is defined id email settings %s", new Object[]{ett}));
                return;
            }
            if (ett.getPolicy() == EmailPollerPolicy.MOVE_TO_FOLDER && TextUtil.isBlank((String)ett.getMoveToFolderName())) {
                IbusEmailInEndpoint.log.warn(String.format("no MoveToFolderName is defined in email settings %s", new Object[]{ett}));
                return;
            }
            try {
                protocol = this.getProtocol(ett.getProtocol());
                uri = new URI(protocol + "://" + ett.getEmail());
                host = uri.getHost();
                port = uri.getPort();
                if (-1 == port) {
                    port = this.getDefaultPort(ett.getProtocol());
                }
                userName = uri.getUserInfo();
                password = ett.getPassword();
                session = Session.getInstance((Properties)this.getMailProperties(protocol, host, port, userName, password), (Authenticator)new MailAuthenticator(userName, password));
                store = session.getStore(protocol);
                try {
                    store.connect(host, port, userName, password);
                    folderName = ett.getInputFolderName();
                    if (TextUtil.isBlank((String)folderName)) {
                        folderName = "INBOX";
                    }
                    if ((folder = store.getFolder(folderName)) == null || !folder.exists()) {
                        throw new IntegrationBusException("folder not found or invalid: " + folder);
                    }
                    folder.open(2);
                    count = folder.getMessageCount();
                    if (0 == count) {
                        return;
                    }
                    messages = folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false));
                    ** if (null != messages && messages.length != 0) goto lbl-1000
lbl42:
                    // 1 sources

                    return;
lbl-1000:
                    // 1 sources

                    {
                        copyTo = ett.getPolicy() == EmailPollerPolicy.MOVE_TO_FOLDER ? ett.getMoveToFolderName() : null;
                        delete = ett.getPolicy() == EmailPollerPolicy.DELETE || ett.getPolicy() == EmailPollerPolicy.MOVE_TO_FOLDER;
                        lock = new CountDownLatch(messages.length);
                        for (final Message message : messages) {
                            if (message.getFlags().contains(Flags.Flag.DELETED)) {
                                lock.countDown();
                                continue;
                            }
                            doc = new MailDocument();
                            part = new MailPart();
                            part.setContentType(ContentType.TEXT);
                            if (message.getContent() instanceof Multipart) {
                                bodyPart = this.getBodyPart((Multipart)message.getContent());
                                if (bodyPart != null) {
                                    body = (String)bodyPart.getContent();
                                    part.setContentType(HttpHelper.getContentType((String)bodyPart.getContentType()));
                                } else {
                                    body = null;
                                }
                            } else {
                                body = (String)message.getContent();
                                part.setContentType(ContentType.TEXT);
                            }
                            part.setData(body == null ? null : body.getBytes("utf-8"));
                            doc.setBody(part);
                            header = this.getHeader(message, "From");
                            if (header != null) {
                                mailAddress = new MailAddress();
                                mailAddress.setName("From");
                                mailAddress.setAddress(header);
                                doc.setFrom(mailAddress);
                            }
                            if ((header = this.getHeader(message, "To")) != null) {
                                mailAddress = new MailAddress();
                                mailAddress.setName("To");
                                mailAddress.setAddress(header);
                                doc.setFrom(mailAddress);
                            }
                            doc.setSubject(IbusEmailInEndpoint.decodeText(this.getHeader(message, "Subject")));
                            attachments = null;
                            content = message.getContent();
                            if (content instanceof Multipart) {
                                attachments = new HashMap<String, DataHandler>();
                                this.extractAttachmentsFromMultipart((Multipart)content, attachments);
                            }
                            if (attachments != null && attachments.size() > 0) {
                                for (Map.Entry<K, V> entry : attachments.entrySet()) {
                                    name = (String)entry.getKey();
                                    dh = (DataHandler)entry.getValue();
                                    baos = new ByteArrayOutputStream();
                                    try {
                                        IoUtil.copyStream((InputStream)dh.getInputStream(), (OutputStream)baos, (int)4096);
                                        data = baos.toByteArray();
                                    }
                                    finally {
                                        baos.close();
                                    }
                                    mailPart = new MailPart();
                                    mailPart.setName(name);
                                    mailPart.setData(data);
                                    if (name == null) continue;
                                    contentType = HttpHelper.getContentType((String)dh.getContentType());
                                    mailPart.setContentType(contentType != null ? contentType : ContentType.BINARY);
                                }
                            }
                            ctx = new MessageContext();
                            ctx.putObject((Enum)IBusStandardContextKeys.EMAIL_MESSAGE, (Object)doc);
                            msg = new IbusMessage();
                            msg.setMessageContext(ctx);
                            currentUser = LogicalStorage.get().getUser();
                            currentLocale = LocaleManager.get().getCurrentLocale();
                            this.clb.execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        LogicalStorage.get().setUser(currentUser);
                                        Locale locale = currentLocale;
                                        if (locale != null) {
                                            LocaleManager.get().setCurrentLocale(locale);
                                        }
                                        IbusEmailInEndpoint.this.sendMessage(msg);
                                        if (copyTo != null) {
                                            Folder destFolder = store.getFolder(copyTo);
                                            if (!destFolder.exists()) {
                                                destFolder.create(1);
                                            }
                                            folder.copyMessages(new Message[]{message}, destFolder);
                                        }
                                        if (delete) {
                                            message.setFlag(Flags.Flag.DELETED, true);
                                        } else {
                                            message.setFlag(Flags.Flag.SEEN, true);
                                        }
                                    }
                                    catch (Exception e) {
                                        log.error("error occurred during process mail message", (Throwable)e);
                                    }
                                    finally {
                                        lock.countDown();
                                    }
                                }
                            });
                        }
                        lock.await();
                        break block38;
                    }
                    finally {
                        if (folder.isOpen()) {
                            folder.close(true);
                        }
                    }
                }
                finally {
                    if (store != null && store.isConnected()) {
                        store.close();
                    }
                }
            }
            catch (Exception e) {
                IbusEmailInEndpoint.log.error("error while polling email endpoint " + this.descr.getId(), (Throwable)e);
            }
        }
    }

    private String getHeader(Message message, String name) throws MessagingException {
        String[] values = message.getHeader(name);
        return values != null ? values[values.length - 1] : null;
    }

    protected Part getBodyPart(Multipart mp) throws MessagingException {
        for (int i = 0; i < mp.getCount(); ++i) {
            String disposition;
            BodyPart part = mp.getBodyPart(i);
            if (part.isMimeType("multipart/*") || (disposition = part.getDisposition()) != null && (disposition.equalsIgnoreCase("attachment") || disposition.equalsIgnoreCase("inline"))) continue;
            return part;
        }
        return null;
    }

    protected void extractAttachmentsFromMultipart(Multipart mp, Map<String, DataHandler> map) throws MessagingException, IOException {
        for (int i = 0; i < mp.getCount(); ++i) {
            BodyPart part = mp.getBodyPart(i);
            if (part.isMimeType("multipart/*")) {
                this.extractAttachmentsFromMultipart((Multipart)part.getContent(), map);
                continue;
            }
            String disposition = part.getDisposition();
            String fileName = part.getFileName();
            if ((disposition == null || !disposition.equalsIgnoreCase("attachment") && !disposition.equalsIgnoreCase("inline")) && fileName == null) continue;
            if (!map.containsKey(fileName)) {
                map.put(fileName, part.getDataHandler());
                continue;
            }
            log.warn("cannot extract duplicate file attachment: " + fileName + ".");
        }
    }

    private Properties getMailProperties(String protocol, String host, int port, String userName, String password) throws Exception {
        Properties properties = (Properties)System.getProperties().clone();
        properties.put("mail." + protocol + ".connectiontimeout", (Object)30000);
        properties.put("mail." + protocol + ".timeout", (Object)30000);
        properties.put("mail." + protocol + ".host", host);
        properties.put("mail." + protocol + ".port", "" + port);
        if (userName != null) {
            properties.put("mail." + protocol + ".user", userName);
            properties.put("mail.user", userName);
            properties.put("mail." + protocol + ".auth", "true");
        } else {
            properties.put("mail." + protocol + ".auth", "false");
        }
        properties.put("mail.transport.protocol", protocol);
        properties.put("mail.store.protocol", protocol);
        properties.put("mail.host", host);
        if (this.isSecureProtocol(protocol)) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            properties.put("mail." + protocol + ".socketFactory", sc.getSocketFactory());
            properties.put("mail." + protocol + ".socketFactory.fallback", "false");
            properties.put("mail." + protocol + ".socketFactory.port", "" + port);
        }
        return properties;
    }

    public boolean isSecureProtocol(String protocol) {
        return protocol.equalsIgnoreCase("smtps") || protocol.equalsIgnoreCase("pop3s") || protocol.equalsIgnoreCase("imaps");
    }

    protected static String decodeText(String subject) throws DecoderException {
        if (subject == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int p = subject.indexOf("=?");
        if (p >= 0) {
            sb.append(subject.substring(0, p));
        }
        String encoded = p < 0 ? subject : subject.substring(p);
        for (String part : encoded.split("\r\n ")) {
            Matcher matcher = PATTERN.matcher(part);
            if (matcher.find()) {
                String method = matcher.group(2);
                String contentToDecode = matcher.group();
                String text = "B".equalsIgnoreCase(method) ? new BCodec().decode(contentToDecode) : new QCodec().decode(contentToDecode);
                sb.append(text);
                continue;
            }
            sb.append(part);
        }
        return sb.toString();
    }

    private String getProtocol(EmailServerProtocol protocol) {
        if (protocol == null) {
            return "pop3";
        }
        switch (protocol) {
            case IMAP: {
                return "imap";
            }
            case IMAPS: {
                return "imaps";
            }
            case POP3: {
                return "pop3";
            }
            case POP3S: {
                return "pop3s";
            }
            case SMTP: {
                return "smtp";
            }
            case SMTPS: {
                return "smtps";
            }
        }
        return "pop3";
    }

    private int getDefaultPort(EmailServerProtocol protocol) {
        if (protocol == null) {
            return 110;
        }
        switch (protocol) {
            case IMAP: {
                return 143;
            }
            case IMAPS: {
                return 993;
            }
            case POP3: {
                return 110;
            }
            case POP3S: {
                return 995;
            }
            case SMTP: {
                return 25;
            }
            case SMTPS: {
                return 465;
            }
        }
        return 110;
    }

    public void refreshPollingSettings() {
    }

    public EndpointType getType() {
        return EndpointType.EMAIL_IN;
    }

    public static class IbusEmailInEndpointFactory
    implements IbusStartPoint.IbusStartPointFactory<IbusEmailInEndpoint> {
        public IbusEmailInEndpoint createStartPoint(IbusStartPoint.IbusStartPointFactoryCallback pipe, String pointId) {
            return new IbusEmailInEndpoint(pointId, pipe);
        }

        public EndpointType getType() {
            return EndpointType.EMAIL_IN;
        }
    }

    private static class MailAuthenticator
    extends Authenticator {
        private final String username;
        private final String password;

        public MailAuthenticator(String username, String password) {
            this.password = password;
            this.username = username;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

