/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.impl.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusEndPoint;
import com.gridnine.xtrip.server.ibus.impl.standard.model.IbusMessage;
import com.gridnine.xtrip.server.ibus.model.EmailOutEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.EndpointType;
import com.gridnine.xtrip.server.model.mail.MailSender;
import org.slf4j.LoggerFactory;

public class IbusEmailOutEndpoint
implements IbusEndPoint {
    private final EmailOutEndpointDescription descr;

    public IbusEmailOutEndpoint(String pointId) {
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        this.descr = (EmailOutEndpointDescription)reg.getEndpoint(pointId, EmailOutEndpointDescription.class);
    }

    public void sendMessage(IbusMessage msg) throws Exception {
        String key;
        MessageContext ctx = msg.getMessageContext();
        MailDocument maildoc = (MailDocument)ctx.getObject(key = this.descr.getDocumentKey() == null ? IBusStandardContextKeys.MAIL_DOCUMENT.name() : this.descr.getDocumentKey());
        if (maildoc == null) {
            LoggerFactory.getLogger(IbusEmailOutEndpoint.class).error("mail document is absent under key " + key);
            return;
        }
        ((MailSender)Environment.getPublished(MailSender.class)).send(maildoc);
    }

    public static class IbusEmailOutEndpointFactory
    implements IbusEndPoint.IbusEndPointFactory<IbusEmailOutEndpoint> {
        public IbusEmailOutEndpoint createEndPoint(String pointId) {
            return new IbusEmailOutEndpoint(pointId);
        }

        public EndpointType getType() {
            return EndpointType.JMS_QUEUE_OUT;
        }
    }
}

