/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.payment.documents;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverterRegistry;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.util.TextUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentDocumentsIbusHelper {
    private static final Logger log = LoggerFactory.getLogger(PaymentDocumentsIbusHelper.class);
    public static final PersonalLocalizableNameFormatter nameFormatter = new PersonalLocalizableNameFormatter("L f m");

    public static String getAmountString(BigDecimal amount, String currency, Locale locale) {
        Number2WordsConverter converter = ((Number2WordsConverterRegistry)Environment.getPublished(Number2WordsConverterRegistry.class)).findConverter(locale, currency);
        if (converter != null) {
            try {
                return TextUtil.capitalize((String)converter.toCurrencyWords(amount, currency, false, false, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static class ImageData {
        private final InputStream data;
        private final int width;
        private final int height;

        public ImageData(byte[] content) {
            ByteArrayInputStream is = null;
            BufferedImage image = null;
            if (content != null) {
                is = new ByteArrayInputStream(content);
                try {
                    image = ImageIO.read(is);
                    ((InputStream)is).reset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.data = is;
            this.width = image != null ? image.getWidth() : 0;
            this.height = image != null ? image.getHeight() : 0;
        }

        public InputStream getData() {
            return this.data;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

