/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.payment.documents;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.PaymentDocumentHandler;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PaymentDocumentSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.Signature;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.payment.documents.PaymentDocumentsIbusHelper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRImageRenderer;

public class PaymentDocumentsRenderFillParametersCommonProcessor
extends BaseProcessor {
    private static final String DATE = "DATE";
    private static final String NUMBER = "NUMBER";
    private static final String ISSUE_DATE = "ISSUE_DATE";
    private static final String TOTAL_AMOUNT = "TOTAL_AMOUNT";
    private static final String TOTAL_AMOUNT_STRING = "TOTAL_AMOUNT_STRING";
    private static final String AGENCY_NAME = "AGENCY_NAME";
    private static final String AGENCY_OKPO = "AGENCY_OKPO";
    private static final String AGENCY_STAMP = "AGENCY_STAMP";

    public void process(MessageContext context) throws Exception {
        EntityContainer documentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BASE_PAYMEMT_DOCUMENT_CONTAINER);
        BasePaymentDocument document = (BasePaymentDocument)documentContainer.getEntity();
        PaymentDocumentSettings settings = (PaymentDocumentSettings)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PAYMENT_DOCUMENTS_SETTINGS);
        Map parameters = (Map)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PARAMETERS);
        Locale locale = (Locale)context.getMandatoryObject((Enum)IBusFinanceContextKeys.LOCALE);
        PaymentDocumentHandler handler = HandlersRegistry.get().findPaymentDocumentHandler(document.getClass());
        if (handler != null) {
            EntityReference agencyReference;
            Date date = new Date();
            parameters.put("REPORT_LOCALE", locale);
            parameters.put(DATE, date);
            parameters.put(NUMBER, TextUtil.buildFullNumber((CompositeNumber)document));
            parameters.put(ISSUE_DATE, document.getDate());
            if (document.getTotalAmount() != null && document.getTotalAmount().getValue() != null && document.getTotalAmount().getCurrency() != null) {
                BigDecimal amount = document.getTotalAmount().getValue();
                String currency = document.getTotalAmount().getCurrency();
                parameters.put(TOTAL_AMOUNT, amount);
                parameters.put(TOTAL_AMOUNT_STRING, PaymentDocumentsIbusHelper.getAmountString(amount, currency, locale));
            }
            if ((agencyReference = document.getOrganization()) == null) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.PaymentDocuments_renderAgencyNotDefined, (String)L10nResourcesManager.getStr((String)Messages.PaymentDocuments_renderAgencyEmpty, (Object[])new Object[0]), (Object[])new Object[0]));
                throw new Exception("rendering failed");
            }
            EntityContainer agencyContainer = EntityStorage.get().resolve(agencyReference);
            if (agencyContainer == null) {
                context.addMessage(MessageHelper.createWarningMessage((String)Messages.PaymentDocuments_renderAgencyNotFound, (String)L10nResourcesManager.getStr((String)Messages.PaymentDocuments_organizationLoadFailed, (Object[])new Object[]{agencyReference}), (Object[])new Object[0]));
                throw new Exception("rendering failed");
            }
            Organization agency = (Organization)agencyContainer.getEntity();
            parameters.put(AGENCY_NAME, ProfileHelper.getFullName((String)agency.getCode(), (L10nString)agency.getShortName(), (L10nString)agency.getFullName(), (DictionaryReference)agency.getLegalForm(), (Locale)locale, (boolean)false));
            parameters.put(AGENCY_OKPO, agency.getOkpoCode());
            for (Signature signature : settings.getSignatures()) {
                EntityContainer signerContainer;
                if (signature.getPosition() == null || (signerContainer = signature.isUseAgent() ? EntityStorage.get().resolve(handler.getCashier(document)) : EntityStorage.get().resolve(signature.getSigner())) == null) continue;
                Person signer = (Person)signerContainer.getEntity();
                String name = PaymentDocumentsIbusHelper.nameFormatter.format((PersonalLocalizableName)signerContainer.getEntity(), locale, false);
                if (!TextUtil.isBlank((String)signature.getComment())) {
                    name = name + " " + signature.getComment();
                }
                parameters.put(String.format("AGENCY_%s_NAME", signature.getPosition().getCode()), name);
                String title = signature.getTitle().toString(locale);
                if (TextUtil.isBlank((String)title)) {
                    title = signature.getPosition().toString(locale);
                }
                parameters.put(String.format("AGENCY_%s_TITLE", signature.getPosition().getCode()), title);
                parameters.put(String.format("AGENCY_%s_COMMENT", signature.getPosition().getCode()), signature.getComment());
                if (!settings.isUseFacsimile() || signer.getSignatureImage() == null) continue;
                PaymentDocumentsIbusHelper.ImageData imageData = new PaymentDocumentsIbusHelper.ImageData(signer.getSignatureImage());
                parameters.put(String.format("AGENCY_%s_SIGNATURE", signature.getPosition().getCode()), JRImageRenderer.getInstance((byte[])signer.getSignatureImage()));
                parameters.put(String.format("AGENCY_%s_SIGNATURE_WIDTH", signature.getPosition().getCode()), imageData.getWidth());
                parameters.put(String.format("AGENCY_%s_SIGNATURE_HEIGHT", signature.getPosition().getCode()), imageData.getWidth());
            }
            if (settings.getStamp() != null) {
                parameters.put(AGENCY_STAMP, JRImageRenderer.getInstance((byte[])settings.getStamp()));
            }
        }
    }
}

