/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.payment.documents;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.PaymentDocumentType;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.PaymentDocumentHandler;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PaymentDocumentSettings;
import com.gridnine.xtrip.common.model.profile.PaymentDocumentsProperties;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.PaymentDocumentHelper;

public class PaymentDocumentsRenderLoadPaymentDocumentsSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityContainer documentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BASE_PAYMEMT_DOCUMENT_CONTAINER);
        BasePaymentDocument document = (BasePaymentDocument)documentContainer.getEntity();
        EntityReference organizationReference = document.getOrganization();
        PaymentDocumentsProperties properties = PaymentDocumentHelper.getPaymentDocumentsProperties((EntityReference<Organization>)organizationReference, false);
        if (properties == null) {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.PaymentDocuments_renderPaymentDocumentsPropertiesNotDefined, (String)L10nResourcesManager.getStr((String)Messages.PaymentDocuments_renderPaymentDocumentsPropertiesNotFound, (Object[])new Object[]{organizationReference}), (Object[])new Object[0]));
            throw new Exception("preparing failed");
        }
        PaymentDocumentHandler handler = HandlersRegistry.get().findPaymentDocumentHandler(document.getClass());
        PaymentDocumentType type = handler != null ? handler.getDocumentType(document) : null;
        PaymentDocumentSettings paymentDocumentsSettings = properties.getPaymentDocumentsSettings().stream().filter(item -> item.getType() == type).findFirst().orElse(null);
        if (paymentDocumentsSettings == null) {
            context.addMessage(MessageHelper.createWarningMessage((String)Messages.PaymentDocuments_renderPaymentDocumentsSettingsNotDefined, (String)L10nResourcesManager.getStr((String)Messages.PaymentDocuments_renderPaymentDocumentsSettingsNotFound, (Object[])new Object[]{type, organizationReference}), (Object[])new Object[0]));
            throw new Exception("preparing failed");
        }
        context.putObject((Enum)IBusFinanceContextKeys.PAYMENT_DOCUMENTS_SETTINGS, (Object)paymentDocumentsSettings);
    }
}

