/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.IBusStandardModelContextKeys;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleUnfinishedReceiptsDebugHandler
implements DebugHandler {
    private static final Logger log = LoggerFactory.getLogger(HandleUnfinishedReceiptsDebugHandler.class);

    public boolean isTraceData(String processorId, MessageContext ctx) {
        return false;
    }

    public boolean isDebugDataDisabled(MessageContext ctx) {
        return false;
    }

    public void configure(Map<String, String> properties) {
    }

    public void save(DebugData data, MessageContext ctx) throws Exception {
        block6: {
            if (!this.writeDebugData(ctx)) {
                return;
            }
            File folder = this.folder();
            String fileName = this.fileName();
            File file = new File(folder, fileName);
            byte[] debugInfoBytes = data.buildDebugInfo(true).getBytes();
            try {
                FileUtils.writeByteArrayToFile((File)file, (byte[])debugInfoBytes);
            }
            catch (Exception e) {
                try {
                    if (e instanceof FileNotFoundException) {
                        Thread.sleep(1000L);
                        FileUtils.writeByteArrayToFile((File)file, (byte[])debugInfoBytes);
                    }
                }
                catch (Exception e2) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error("unable to save traces to " + fileName, (Throwable)e2);
                }
            }
        }
    }

    private String fileName() {
        return "handle-unfinished-receipts-" + MiscUtil.getTimestamp() + ".xml";
    }

    private File folder() {
        File tempFolder = Environment.getTempFolder();
        String folders = "ibus-receipt/" + new SimpleDateFormat("yyyy/MM/dd").format(new Date());
        File folder = new File(tempFolder, folders);
        if (!tempFolder.exists()) {
            tempFolder.mkdirs();
        }
        return folder;
    }

    private boolean writeDebugData(MessageContext ctx) {
        Object object = ctx.getObject((Enum)IBusStandardModelContextKeys.HANDLE_UNFINISHED_RECEIPTS_WRITE_DEBUG_DATA);
        return Boolean.parseBoolean(String.valueOf(object));
    }
}

