/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.fiscal.PaymentType;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.ReceiptTestBase;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.ReceiptTestHelper;
import com.gridnine.xtrip.server.model.test.TestAirProductBuilder;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestReservationBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class AirProductReceiptTest
extends ReceiptTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        new TestContractBuilderBuilder().supplier(TestBookingFileBuilder.agency).contractType(ContractType.CLIENT).customer().customer(TestBookingFileBuilder.client).end().ruleSettings().target((RuleTarget)Targets.PRODUCT_COMMISSION).fee(10.0, "%", new TestFeePropertiesBuilder().basis(CalculationBasis.TOTAL).create().toReference()).end().create();
    }

    @Test
    public void testSellProduct() throws Exception {
        EntityContainer<BookingFile> testCtr = this.buildBookingContainer(ProductStatus.SELL);
        BaseProduct product = (BaseProduct)BookingHelper.getProducts((BookingFile)((BookingFile)testCtr.getEntity())).iterator().next();
        ReceiptTestHelper.ReceiptValidator validator = new ReceiptTestHelper.ReceiptValidator((EntityReference<BookingFile>)testCtr.toReference(), product.getUid(), true);
        Map<String, Object> ibusContext = ReceiptTestHelper.createIbusContext(Collections.singletonList(testCtr), ReceiptServiceType.ATOL_FISCAL_DEVICE);
        List<EntityContainer<Receipt>> receipts = ReceiptTestHelper.createReceipts(ibusContext);
        Assert.assertEquals((long)1L, (long)receipts.size());
        receipts = ReceiptTestHelper.registerReceipts(ibusContext);
        Receipt receipt = (Receipt)receipts.iterator().next().getEntity();
        validator.validateReceipt(receipt);
        Assert.assertEquals((Object)ReceiptType.SELL, (Object)receipt.getReceiptData().getType());
        Assert.assertEquals((long)5L, (long)receipt.getReceiptData().getItems().size());
        Assert.assertTrue((boolean)receipt.getReceiptData().getItems().stream().anyMatch(line -> line.getLineType() == ReceiptLineType.FEES));
        Assert.assertTrue((boolean)receipt.getReceiptData().getItems().stream().allMatch(line -> line.getPaymentType() == PaymentType.CASH));
    }

    @Test
    public void testRefundProduct() throws Exception {
        EntityContainer<BookingFile> testCtr = this.buildBookingContainer(ProductStatus.REFUND);
        BaseProduct product = (BaseProduct)BookingHelper.getBaseProductsStream((BookingFile)((BookingFile)testCtr.getEntity())).filter(prod -> BookingHelper.getProductStatus((BaseProduct)prod) == ProductStatus.REFUND).iterator().next();
        ReceiptTestHelper.ReceiptValidator validator = new ReceiptTestHelper.ReceiptValidator((EntityReference<BookingFile>)testCtr.toReference(), product.getUid(), true);
        Map<String, Object> ibusContext = ReceiptTestHelper.createIbusContext(Collections.singletonList(testCtr), ReceiptServiceType.ATOL_FISCAL_DEVICE);
        List<Object> receipts = ReceiptTestHelper.createReceipts(ibusContext);
        Assert.assertEquals((long)3L, (long)receipts.size());
        receipts = ReceiptTestHelper.registerReceipts(ibusContext).stream().filter(receipt -> ((Receipt)receipt.getEntity()).getReceiptData().getItems().stream().anyMatch(item -> item.getProductReference().getNestedEntityUid().equals(product.getUid()))).collect(Collectors.toList());
        int penaltyReceipts = 0;
        int sellRefundReceipts = 0;
        for (EntityContainer entityContainer : receipts) {
            Receipt receipt2 = (Receipt)entityContainer.getEntity();
            validator.validateReceipt(receipt2);
            Assert.assertTrue((boolean)receipt2.getReceiptData().getItems().stream().allMatch(line -> line.getPaymentType() == PaymentType.CASH));
            if (receipt2.getReceiptData().getType() == ReceiptType.SELL) {
                ++penaltyReceipts;
                Assert.assertEquals((long)1L, (long)receipt2.getReceiptData().getItems().size());
                continue;
            }
            if (receipt2.getReceiptData().getType() == ReceiptType.SELL_REFUND) {
                ++sellRefundReceipts;
                Assert.assertEquals((long)4L, (long)receipt2.getReceiptData().getItems().size());
                continue;
            }
            Assert.fail((String)"Unsupported receipt type!");
        }
        Assert.assertEquals((long)1L, (long)penaltyReceipts);
        Assert.assertEquals((long)1L, (long)sellRefundReceipts);
    }

    @Test
    public void testExchangeProduct() throws Exception {
        EntityContainer<BookingFile> testCtr = this.buildBookingContainer(ProductStatus.EXCHANGE);
        BaseProduct product = (BaseProduct)BookingHelper.getBaseProductsStream((BookingFile)((BookingFile)testCtr.getEntity())).filter(prod -> BookingHelper.getProductStatus((BaseProduct)prod) == ProductStatus.EXCHANGE).iterator().next();
        ReceiptTestHelper.ReceiptValidator validator = new ReceiptTestHelper.ReceiptValidator((EntityReference<BookingFile>)testCtr.toReference(), product.getUid(), true);
        Map<String, Object> ibusContext = ReceiptTestHelper.createIbusContext(Collections.singletonList(testCtr), ReceiptServiceType.ATOL_FISCAL_DEVICE);
        List<Object> receipts = ReceiptTestHelper.createReceipts(ibusContext);
        Assert.assertEquals((long)3L, (long)receipts.size());
        receipts = ReceiptTestHelper.registerReceipts(ibusContext).stream().filter(receipt -> ((Receipt)receipt.getEntity()).getReceiptData().getItems().stream().anyMatch(item -> item.getProductReference().getNestedEntityUid().equals(product.getUid()))).collect(Collectors.toList());
        int penaltyReceipts = 0;
        int sellRefundReceipts = 0;
        for (EntityContainer entityContainer : receipts) {
            Receipt receipt2 = (Receipt)entityContainer.getEntity();
            validator.validateReceipt(receipt2);
            Assert.assertTrue((boolean)receipt2.getReceiptData().getItems().stream().allMatch(line -> line.getPaymentType() == PaymentType.OTHER));
            if (receipt2.getReceiptData().getType() == ReceiptType.SELL) {
                ++penaltyReceipts;
                Assert.assertEquals((long)1L, (long)receipt2.getReceiptData().getItems().size());
                continue;
            }
            if (receipt2.getReceiptData().getType() == ReceiptType.SELL_REFUND) {
                ++sellRefundReceipts;
                Assert.assertEquals((long)4L, (long)receipt2.getReceiptData().getItems().size());
                continue;
            }
            Assert.fail((String)"Unsupported receipt type!");
        }
        Assert.assertEquals((long)1L, (long)penaltyReceipts);
        Assert.assertEquals((long)1L, (long)sellRefundReceipts);
    }

    @Test
    public void testVoidProduct() throws Exception {
        EntityContainer<BookingFile> testCtr = this.buildBookingContainer(ProductStatus.VOID);
        ((BookingFile)testCtr.getEntity()).getReservations().forEach(r -> r.getProducts().removeIf(p -> p instanceof ProductVoiding));
        BaseProduct product = (BaseProduct)BookingHelper.getProducts((BookingFile)((BookingFile)testCtr.getEntity())).iterator().next();
        ReceiptTestHelper.ReceiptValidator validator = new ReceiptTestHelper.ReceiptValidator((EntityReference<BookingFile>)testCtr.toReference(), product.getUid(), true);
        Map<String, Object> ibusContext = ReceiptTestHelper.createIbusContext(Collections.singletonList(testCtr), ReceiptServiceType.ATOL_FISCAL_DEVICE);
        List<EntityContainer<Receipt>> receipts = ReceiptTestHelper.createReceipts(ibusContext);
        Assert.assertEquals((long)1L, (long)receipts.size());
        receipts = ReceiptTestHelper.registerReceipts(ibusContext);
        Receipt receipt = (Receipt)receipts.iterator().next().getEntity();
        validator.validateReceipt(receipt);
        Assert.assertEquals((Object)ReceiptType.SELL_REFUND, (Object)receipt.getReceiptData().getType());
        Assert.assertEquals((long)5L, (long)receipt.getReceiptData().getItems().size());
        Assert.assertTrue((boolean)receipt.getReceiptData().getItems().stream().anyMatch(line -> line.getLineType() == ReceiptLineType.FEES));
        Assert.assertTrue((boolean)receipt.getReceiptData().getItems().stream().allMatch(line -> line.getPaymentType() == PaymentType.CASH));
    }

    private EntityContainer<BookingFile> buildBookingContainer(ProductStatus status) throws Exception {
        TestReservationBuilder reservationBuilder = new TestBookingFileBuilder().reservation();
        TestAirProductBuilder productBuilder = this.buildAirProduct(reservationBuilder, status);
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            TestAirProductBuilder previousProductBuilder = this.buildAirProduct(reservationBuilder, ProductStatus.SELL).updateFops();
            previousProductBuilder.nextProduct(productBuilder.getEntity());
            productBuilder.previousProduct(previousProductBuilder.getEntity());
            productBuilder.penalty(600.0);
        }
        return productBuilder.updateFops().end().end().create();
    }

    private TestAirProductBuilder buildAirProduct(TestReservationBuilder reservationBuilder, ProductStatus status) throws Exception {
        return reservationBuilder.airProduct().agency(TestBookingFileBuilder.agency).status(status).systemNumber("123456789").fare(1000.0).tax("YQ", 100.0).tax("ZZ", 300.0).tax("XX", 500.0).passengerType((DictionaryReference)new PassengerTypeReference("ADULT")).traveller(new Traveller());
    }
}

