/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal;

import com.gridnine.xtrip.common.fiscal.model.FiscalSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.CalculationBasis;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.FiscalCategory;
import com.gridnine.xtrip.common.model.dict.FiscalCategoryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptClient;
import com.gridnine.xtrip.common.model.fiscal.ReceiptData;
import com.gridnine.xtrip.common.model.fiscal.ReceiptDataType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalActions;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalProperties;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalTargets;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.ReceiptTestBase;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.ReceiptTestHelper;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestReservationBuilder;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class CommonReceiptTest
extends ReceiptTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        new TestContractBuilderBuilder().supplier(TestBookingFileBuilder.agency).contractType(ContractType.CLIENT).customer().customer(TestBookingFileBuilder.client).end().ruleSettings().target((RuleTarget)Targets.HOTELS_COMMISSION).fee(10.0, "%", new TestFeePropertiesBuilder().basis(CalculationBasis.TOTAL).create().toReference()).end().create();
    }

    @Test
    public void testReceiptCancellation() throws Exception {
        TestReservationBuilder reservationBuilder = new TestBookingFileBuilder().reservation();
        this.buildTestProduct(reservationBuilder);
        EntityContainer bookingCtr = reservationBuilder.end().create();
        ArrayList<EntityContainer<Receipt>> cancelledReceipts = new ArrayList<EntityContainer<Receipt>>();
        Map<String, Object> ibusContext = ReceiptTestHelper.createIbusContext(Collections.singletonList(bookingCtr), ReceiptServiceType.ATOL_FISCAL_DEVICE);
        List<EntityContainer<Receipt>> list = ReceiptTestHelper.createReceipts(ibusContext);
        Assert.assertEquals((long)1L, (long)list.size());
        ReceiptTestHelper.registerReceipts(ibusContext);
        bookingCtr = EntityStorage.get().resolve(bookingCtr.toReference());
        ibusContext = ReceiptTestHelper.createIbusContext(Collections.singletonList(bookingCtr), ReceiptServiceType.ATOL_FISCAL_DEVICE);
        List<EntityContainer<Receipt>> list2 = ReceiptTestHelper.createCancelReceipts(ibusContext);
        Assert.assertEquals((long)1L, (long)list2.size());
        List<EntityContainer<Receipt>> list3 = ReceiptTestHelper.registerCancelReceipts(ibusContext);
        cancelledReceipts.addAll(list3);
        for (EntityContainer entityContainer : cancelledReceipts) {
            Receipt receipt = (Receipt)entityContainer.getEntity();
            EntityContainer previousReceiptCtr = EntityStorage.get().resolve(receipt.getPreviousReceipt());
            Assert.assertNotNull((Object)previousReceiptCtr);
            Receipt previousReceipt = (Receipt)previousReceiptCtr.getEntity();
            Assert.assertEquals((Object)previousReceipt.getNextReceipt(), (Object)entityContainer.toReference());
            Assert.assertEquals((Object)previousReceipt.getOwner(), (Object)receipt.getOwner());
            ReceiptData receiptData = receipt.getReceiptData();
            ReceiptData previousReceiptData = previousReceipt.getReceiptData();
            Assert.assertNotEquals((Object)previousReceiptData.getType(), (Object)receiptData.getType());
            Assert.assertEquals((Object)previousReceiptData.getCategories(), (Object)receiptData.getCategories());
            Assert.assertEquals((Object)previousReceiptData.getAgency(), (Object)receiptData.getAgency());
            Assert.assertEquals((Object)previousReceiptData.getClentEmail(), (Object)receiptData.getClentEmail());
            if (previousReceiptData.getReceiptClient() != null) {
                ReceiptClient previousReceiptClient = previousReceiptData.getReceiptClient();
                ReceiptClient receiptClient = receiptData.getReceiptClient();
                Assert.assertNotNull((Object)receiptClient);
                Assert.assertEquals((Object)previousReceiptClient.getINN(), (Object)receiptClient.getINN());
                Assert.assertEquals((Object)previousReceiptClient.getName(), (Object)receiptClient.getName());
                Assert.assertEquals((Object)previousReceiptClient.getProfileReference(), (Object)receiptClient.getProfileReference());
            }
            Map<NestedEntityReference, List<ReceiptLine>> previousReceiptDataItemsMap = previousReceiptData.getItems().stream().collect(Collectors.groupingBy(ReceiptLine::getFopComponent));
            Map<NestedEntityReference, List<ReceiptLine>> receiptDataItemsMap = receiptData.getItems().stream().collect(Collectors.groupingBy(ReceiptLine::getFopComponent));
            previousReceiptDataItemsMap.forEach((ref, previousLines) -> {
                List lines = (List)receiptDataItemsMap.get(ref);
                Assert.assertNotNull((Object)lines);
                Assert.assertEquals((long)1L, (long)lines.size());
                Assert.assertEquals((long)1L, (long)previousLines.size());
                ReceiptLine line = (ReceiptLine)lines.iterator().next();
                ReceiptLine previousLine = (ReceiptLine)previousLines.iterator().next();
                Assert.assertEquals((Object)previousLine.getPaymentType(), (Object)line.getPaymentType());
                Assert.assertEquals((Object)previousLine.getPaymentMethod(), (Object)line.getPaymentMethod());
                Assert.assertEquals((Object)previousLine.getPrice(), (Object)line.getPrice());
                Assert.assertEquals((Object)previousLine.getTotal(), (Object)line.getTotal());
                Assert.assertEquals((Object)previousLine.getProductReference(), (Object)line.getProductReference());
                Assert.assertEquals((Object)previousLine.getLineType(), (Object)line.getLineType());
                Assert.assertEquals((Object)previousLine.getQuantity(), (Object)line.getQuantity());
                Assert.assertEquals((Object)previousLine.getVatType(), (Object)line.getVatType());
                Assert.assertEquals((Object)previousLine.getVatAmount(), (Object)line.getVatAmount());
                Assert.assertEquals((Object)previousLine.getSupplier(), (Object)line.getSupplier());
                Assert.assertEquals((Object)previousLine.getPrintName(), (Object)line.getPrintName());
            });
        }
    }

    @Test
    public void testReceiptSplitting() throws Exception {
        TestReservationBuilder reservationBuilder = new TestBookingFileBuilder().reservation();
        this.buildTestProduct(reservationBuilder);
        List<EntityContainer<BookingFile>> containers = Collections.singletonList(reservationBuilder.end().create());
        FiscalCategory feesCategory = new FiscalCategory();
        feesCategory.setCode("FEES");
        DictionaryStorage.get().save((BaseDictionary)feesCategory);
        EntityContainer fiscalSettings = EntityStorage.get().load(FiscalSettings.class, "fiscal-settings");
        RuleRestriction restriction = new RuleRestriction();
        restriction.setProperty((RuleProperty)FiscalProperties.FISCAL_RECEIPT_ITEM_POSITION_TYPE);
        restriction.setCondition((RuleCondition)Conditions.EQUALS);
        restriction.setValue(Collections.singletonList(ReceiptDataType.FEES));
        RuleResult ruleResult = new RuleResult();
        ruleResult.setAction((RuleAction)FiscalActions.FISCAL_RECEIPT_ITEM_CATEGORY);
        ruleResult.setValue((Object)new FiscalCategoryReference("FEES"));
        RuleSettings ruleSettings = new RuleSettings();
        ruleSettings.setTarget((RuleTarget)FiscalTargets.FISCAL_RECEIPT_ITEM);
        ruleSettings.getRestrictions().add(restriction);
        ruleSettings.getResults().add(ruleResult);
        ((FiscalSettings)fiscalSettings.getEntity()).getRuleSet().setModified(new Date());
        ((FiscalSettings)fiscalSettings.getEntity()).getRuleSet().getRules().add(ruleSettings);
        EntityStorage.get().save(fiscalSettings, true);
        Map<String, Object> ibusContext = ReceiptTestHelper.createIbusContext(containers, ReceiptServiceType.ATOL_FISCAL_DEVICE);
        List<EntityContainer<Receipt>> receipts = ReceiptTestHelper.createReceipts(ibusContext);
        Assert.assertEquals((long)2L, (long)receipts.size());
        ((FiscalSettings)fiscalSettings.getEntity()).getRuleSet().getRules().clear();
        EntityStorage.get().save(fiscalSettings, true);
        ibusContext = ReceiptTestHelper.createIbusContext(containers, ReceiptServiceType.ATOL_FISCAL_DEVICE);
        receipts = ReceiptTestHelper.createReceipts(ibusContext);
        Assert.assertEquals((long)1L, (long)receipts.size());
    }

    @Test
    public void testReceiptCount() throws Exception {
        TestReservationBuilder reservationBuilder = new TestBookingFileBuilder().reservation();
        for (int i = 0; i < 3; ++i) {
            this.buildTestProduct(reservationBuilder);
        }
        List<EntityContainer<BookingFile>> containers = Collections.singletonList(reservationBuilder.end().create());
        Map<String, Object> ibusContext = ReceiptTestHelper.createIbusContext(containers, ReceiptServiceType.ATOL_FISCAL_DEVICE);
        List<EntityContainer<Receipt>> receipts = ReceiptTestHelper.createReceipts(ibusContext);
        Assert.assertEquals((long)3L, (long)receipts.size());
    }

    private void buildTestProduct(TestReservationBuilder reservationBuilder) throws Exception {
        reservationBuilder.hotelProduct().agency(TestBookingFileBuilder.agency).room(500.0).traveller(new Traveller()).status(ProductStatus.SELL).updateFops().end().end().create();
    }
}

