/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.receipt.fiscal;

import com.gridnine.xtrip.common.fiscal.model.FiscalSettings;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.fiscal.PaymentMethod;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.fiscal.ReceiptDataType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLine;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptServiceType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptType;
import com.gridnine.xtrip.common.model.fiscal.ReceiptVatType;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectProductProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectReceiptLineProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.format.object.Format;
import com.gridnine.xtrip.server.model.ibus.receipt.fiscal.createReceipt.batch.ReceiptLineValueHolder;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class IbusFiscalReceiptHelper {
    private static final String DEFAULT_PRODUCT_NAME_PATTERN = String.format("{id=%s:%s}[padding= |value={id=%s:%s}][padding= |value={id=%s:%s}]", ModelFormatObjects.PRODUCT.getId(), ModelFormatObjectProductProperties.TYPE.getId(), ModelFormatObjects.PRODUCT.getId(), ModelFormatObjectProductProperties.CARRIER_NUMBER.getId(), ModelFormatObjects.PRODUCT.getId(), ModelFormatObjectProductProperties.NUMBER.getId());

    public static FiscalSettings getFiscalSettings() {
        EntityContainer loadCtr = EntityStorage.get().load(FiscalSettings.class, "fiscal-settings");
        if (loadCtr == null) {
            throw Xeption.forDeveloper((String)"Missing fiscal-settings!", (Object[])new Object[0]);
        }
        return (FiscalSettings)loadCtr.getEntity();
    }

    public static String getPrintName(ReceiptLineValueHolder holder, String pattern, EntityStorageContext storageContext) {
        ReceiptLine receiptLine = holder.getReceiptLine();
        ReceiptLineType lineType = receiptLine.getLineType();
        switch (lineType) {
            case PRODUCT: {
                return TextUtil.isBlank((String)pattern) ? IbusFiscalReceiptHelper.getPrintName(receiptLine, DEFAULT_PRODUCT_NAME_PATTERN, storageContext) : IbusFiscalReceiptHelper.getPrintName(receiptLine, pattern, storageContext);
            }
            case PENALTY: 
            case FEES: 
            case VENDOR_FEES: 
            case SERVICE: {
                return IbusFiscalReceiptHelper.getPrintName(receiptLine, pattern, storageContext);
            }
            case TAX: {
                return "\u0422\u0430\u043a\u0441\u0430 " + holder.getFopValueHolder().getTaxCode();
            }
        }
        return lineType.toString(LocaleUtil.LOCALE_RU);
    }

    private static String getPrintName(ReceiptLine receiptLine, String pattern, EntityStorageContext storageContext) {
        return Format.of((String)(TextUtil.nonBlank((String)pattern) ? String.format("{id=%s:%s|pattern=%s}", ModelFormatObjects.RECEIPT_LINE.getId(), ModelFormatObjectReceiptLineProperties.PRODUCT.getId(), pattern) : ModelFormatObjects.RECEIPT_LINE.getPattern())).format(Format.FormatObjectDataBuilder.get().object((Object)receiptLine, ModelFormatObjects.RECEIPT_LINE.getId()).build(), storageContext, LocaleHelper.getCurrentLocale());
    }

    public static com.gridnine.xtrip.common.model.fiscal.PaymentType convertPaymentType(PaymentType payment) {
        Map availablePaymentTypes = IbusFiscalReceiptHelper.getFiscalSettings().getAvailablePaymentTypes();
        if (payment == PaymentType.CASH) {
            return com.gridnine.xtrip.common.model.fiscal.PaymentType.CASH;
        }
        if (payment == PaymentType.TICKET) {
            return com.gridnine.xtrip.common.model.fiscal.PaymentType.OTHER;
        }
        if (availablePaymentTypes.get(payment) != null) {
            return (com.gridnine.xtrip.common.model.fiscal.PaymentType)availablePaymentTypes.get(payment);
        }
        return com.gridnine.xtrip.common.model.fiscal.PaymentType.ELECTRONIC;
    }

    public static ReceiptVatType getReceiptVatType(Double rate) {
        if (rate == null) {
            return ReceiptVatType.NONE;
        }
        if (MiscUtil.equals((Object)0.0, (Object)rate)) {
            return ReceiptVatType.VAT_0;
        }
        if (MiscUtil.equals((Object)5.0, (Object)rate)) {
            return ReceiptVatType.VAT_5;
        }
        if (MiscUtil.equals((Object)7.0, (Object)rate)) {
            return ReceiptVatType.VAT_7;
        }
        if (MiscUtil.equals((Object)10.0, (Object)rate)) {
            return ReceiptVatType.VAT_10;
        }
        if (MiscUtil.equals((Object)20.0, (Object)rate)) {
            return ReceiptVatType.VAT_20;
        }
        return null;
    }

    public static ReceiptDataType convertReceiptLineType2ReceiptDataType(ReceiptLineType lineType) {
        switch (lineType) {
            case PRODUCT: 
            case TAX: {
                return ReceiptDataType.PRODUCT;
            }
            case PENALTY: {
                return ReceiptDataType.PENALTY;
            }
            case FEES: {
                return ReceiptDataType.FEES;
            }
            case VENDOR_FEES: {
                return ReceiptDataType.VENDOR_FEES;
            }
            case SERVICE: {
                return ReceiptDataType.SERVICE;
            }
            case TECHNICAL_FEE: {
                return ReceiptDataType.TECHNICAL_FEE;
            }
        }
        throw new IllegalArgumentException("Unsupported receipt line type: " + lineType);
    }

    public static ReceiptLineType convertFopComponentType2ReceiptLineType(FopComponentType componentType) {
        switch (componentType) {
            case PRODUCT: 
            case DEDUCTION: {
                return ReceiptLineType.PRODUCT;
            }
            case PENALTY: {
                return ReceiptLineType.PENALTY;
            }
            case TAXES: {
                return ReceiptLineType.TAX;
            }
            case VENDOR_FEES: {
                return ReceiptLineType.VENDOR_FEES;
            }
            case OWN_FEES: {
                return ReceiptLineType.FEES;
            }
            case SERVICE: {
                return ReceiptLineType.SERVICE;
            }
            case TECHNICAL_PROVIDER_FEES: {
                return ReceiptLineType.TECHNICAL_FEE;
            }
        }
        throw new IllegalArgumentException("Unsupported \u0441omponent type: " + componentType);
    }

    public static PaymentMethod getPaymentMethod(FopComponentType componentType, ReceiptServiceType serviceType) {
        switch (componentType) {
            case PRODUCT: 
            case DEDUCTION: 
            case PENALTY: 
            case TAXES: 
            case SERVICE: {
                return serviceType == ReceiptServiceType.ATOL_FISCAL_DEVICE ? PaymentMethod.FULL_PAYMENT : PaymentMethod.FULL_PREPAYMENT;
            }
        }
        return PaymentMethod.FULL_PAYMENT;
    }

    public static ReceiptType defineReceiptType(BigDecimal amount, Boolean isCancellation, ProductStatus productStatus) {
        BigDecimal value;
        boolean negate = productStatus == ProductStatus.REFUND || productStatus == ProductStatus.EXCHANGE || productStatus == ProductStatus.VOID;
        BigDecimal bigDecimal = value = negate ? amount.negate() : amount;
        return BooleanUtil.nullAsFalse((Boolean)isCancellation) ? (MiscUtil.isNegative((BigDecimal)value) ? ReceiptType.SELL : ReceiptType.SELL_REFUND) : (MiscUtil.isNegative((BigDecimal)value) ? ReceiptType.SELL_REFUND : ReceiptType.SELL);
    }

    public static ReceiptType revertReceiptType(ReceiptType receiptType) {
        Objects.requireNonNull(receiptType, "Receipt type is missing");
        switch (receiptType) {
            case SELL: {
                return ReceiptType.SELL_REFUND;
            }
            case SELL_REFUND: {
                return ReceiptType.SELL;
            }
        }
        throw new IllegalArgumentException("Unsupported receipt type: " + receiptType);
    }

    public static Map<Fop, List<FopComponent>> getFopComponents(BaseProduct product, List<Fop> fops, Boolean isCancellation, EntityStorageContext context) {
        HashMap<Fop, List<FopComponent>> result = new HashMap<Fop, List<FopComponent>>();
        ProductStatus productStatus = ProductHandler.of((BaseProduct)product).getStatus(product);
        for (Fop fop : fops) {
            List components;
            FopDetalization fopDetalization = (FopDetalization)product.getFopDetalizations().get(fop.getUid());
            if (fopDetalization == null || (components = fopDetalization.getComponents().stream().filter(fopComponent -> BooleanUtil.nullAsFalse((Boolean)isCancellation) || fopComponent.getReceipt() == null || productStatus == ProductStatus.VOID && IbusFiscalReceiptHelper.isValidVoidProductFopComponent(fopComponent, context)).collect(Collectors.toList())).isEmpty()) continue;
            result.put(fop, components);
        }
        return result;
    }

    private static boolean isValidVoidProductFopComponent(FopComponent fopComponent, EntityStorageContext context) {
        EntityContainer receiptCtr = EntityStorageHelper.resolve((EntityReference)fopComponent.getReceipt(), (EntityStorageContext)context);
        return ((Receipt)receiptCtr.getEntity()).getReceiptData().getType() == ReceiptType.SELL;
    }
}

